import type { Metadata } from 'next';
import { getStrapiMedia } from './utils';

const createMetadata = (data: any): Metadata => {
  const { name, seo } = data || {};

  const {
    metaTitle,
    metaDescription,
    metaRobots,
    metaImage,
    keywords,
    canonicalURL,
  } = seo || {};

  const seoParams: Metadata = { alternates: {}, openGraph: {} };

  seoParams.title = metaTitle || name;
  seoParams.description = metaDescription || '';
  seoParams.openGraph = {
    title: seoParams.title!,
    description: seoParams.description!,
  };

  if (metaImage?.data?.attributes?.url) {
    seoParams.openGraph.images = getStrapiMedia(metaImage.data.attributes.url)!;
  }

  if (metaRobots) {
    seoParams.robots = metaRobots;
  }

  if (keywords) {
    seoParams.keywords = keywords;
  }

  if (canonicalURL) {
    seoParams.alternates!.canonical = canonicalURL;
  }

  return seoParams;
};

export default createMetadata;
