import { StrapiImageInterface } from '@/shared/ui/StrapiImage/index';
import AboutBanner from '@/widgets/AboutBanner';
import AboutDiscover from '@/widgets/AboutDiscover';
import AboutNumbers from '@/widgets/AboutNumbers';
import Advantages from '@/widgets/Advantages';
import ArticleBanner from '@/widgets/ArticleBanner';
import ArticleFeatureSlider from '@/widgets/ArticleFeatureSlider';
import ArticleMedia from '@/widgets/ArticleMedia';
import ArticleOffered from '@/widgets/ArticleOffered';
import ArticleQuote from '@/widgets/ArticleQuote';
import ArticleSuggested from '@/widgets/ArticleSuggested';
import ArticleText from '@/widgets/ArticleText';
import BannerWithIframe from '@/widgets/BannerWithIframe';
import BrochureSlider from '@/widgets/BrochureSlider/index';
import CareersBanner from '@/widgets/CareersBanner';
import CarouselSlider from '@/widgets/CarouselSlider/index';
import CtaBanner from '@/widgets/CtaBanner';
import CtaButtons from '@/widgets/CtaButtons/index';
import CtaGroup from '@/widgets/CtaGroup/index';
import DealerCta from '@/widgets/DealerCta/index';
import CtaCard from '@/widgets/DealerCta/ui/CtaCard';
import ImageSection from '@/widgets/ImageSection';
import ImageWithSlider from '@/widgets/ImageWithCarousel/index';
import Locations from '@/widgets/Locations';
import ModelBanner from '@/widgets/ModelBanner/index';
import Models from '@/widgets/Models/index';
import ModelsBanner from '@/widgets/ModelsBanner/index';
import ModelsHeader from '@/widgets/ModelsHeader/index';
import News from '@/widgets/News';
import NotFound from '@/widgets/NotFound';
import OfferBanner from '@/widgets/OfferBanner';
import Offers from '@/widgets/Offers';
import { RelatedFilterItem } from '@/widgets/RelatedContent/model/interface';
import TechnicalInfo from '@/widgets/TechnicalInfo';
import Testimonials from '@/widgets/Testimonials/index';
import TextContent from '@/widgets/TextContent';
import TextOverImage from '@/widgets/TextOverImage/index';
import { CATEGORY_KEY, COUNTRY_KEY, PAGE_KEY, SEARCH_KEY } from './constants';

import {
  formatTime,
  getStrapiForm,
  getStrapiCdnUrl,
  getStrapiMedia,
  getStrapiContent,
} from './utils';

const contentBuilder = async ({
  item,
  index,
  lang,
  slug,
  models,
  pageUpdatedAt,
  translates,
  filters,
  searchParams,
}: {
  item: any;
  index: number;
  lang: string;
  slug?: string;
  pageUpdatedAt: string;
  translates: { [key: string]: string };
  searchParams?: any;
  filters?: RelatedFilterItem[];
  models: {
    slug: string;
    img: StrapiImageInterface;
    name: string;
    title: string;
    description: string;
    formValue: string;
  }[];
}) => {
  const key = item.__component + index;

  switch (item.__component) {
    case 'general.featured-product':
      return (
        <ModelBanner
          key={key}
          sectionId={item.sectionId}
          titleType={item.titleType}
          caption={item.caption}
          title={item.title}
          img={item.image?.data?.attributes}
          mobileImg={item.mobileImage?.data?.attributes}
          lang={lang}
          buttons={item.buttons}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.testimonials':
      return (
        <Testimonials
          key={key}
          sectionId={item.sectionId}
          caption={item.caption}
          title={item.title}
          slides={item.testimonials.data.map(({ attributes }: any) => ({
            img: attributes.photo.data.attributes,
            name: attributes.name,
            position: attributes.position,
            rate: attributes.rate,
            description: attributes.text,
          }))}
        />
      );
    case 'general.models-slider':
      return (
        <Models
          key={key}
          lang={lang}
          sectionId={item.sectionId}
          models={models}
          translates={translates}
          testDriveForm={item.testDriveForm}
        />
      );
    case 'general.dealer-cta':
      return <DealerCta key={key} lang={lang} data={item} />;
    case 'general.model-banner':
      return (
        <ModelsBanner
          key={key}
          sectionId={item.sectionId}
          image={item.img.data.attributes}
          title={item.title}
          subtitle={item.description}
          additionalDescription={item.additionalDescription}
          additionalTitle={item.additionalTitle}
          lang={lang}
          additionalButton={item.additionalButton}
          playVideoButton={{
            text: item.playVideoButton?.text,
            videoTitle: item.playVideoButton?.videoTitle,
            url:
              item.playVideoButton?.videoUrl ||
              (item.playVideoButton?.video?.data?.attributes.url &&
                getStrapiMedia(item.playVideoButton.video.data.attributes.url)),
          }}
        />
      );
    case 'general.text-over-image':
      return (
        <TextOverImage
          key={key}
          sectionId={item.sectionId}
          title={item.title}
          description={item.description}
          type={item.type}
          img={item.img.data.attributes}
          desktopType={item.desktopType}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.body-copy-slider-with-label':
      return (
        <CarouselSlider
          key={key}
          sectionId={item.sectionId}
          title={item.title}
          description={item.description}
          cards={item.slides.map(({ title, img }: any) => ({
            img: img?.data?.attributes,
            title,
          }))}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.brochure-slider':
      return (
        <BrochureSlider
          key={key}
          sectionId={item.sectionId}
          brochures={item.slides.map(({ title, img, description }: any) => ({
            img: img?.data?.attributes,
            title,
            description,
          }))}
        />
      );
    case 'general.image-with-carousel':
      return (
        <ImageWithSlider
          key={key}
          sectionId={item.sectionId}
          image={item.img.data.attributes}
          title={item.title}
          subtitle={item.description}
          slides={item.slides.map(({ title, img, description }: any) => ({
            img: img?.data?.attributes,
            title,
            description,
          }))}
        />
      );
    case 'general.model-cta-group':
      return (
        <CtaGroup
          key={key}
          lang={lang}
          sectionId={item.sectionId}
          internalSectionTitle={item.internalSectionTitle}
          cards={item.cards.map(
            ({ title, img, description, link, file, links }: any) => {
              let modifiedLinks = [];

              if (link?.title) {
                let fileUrl = file.data?.[0].attributes?.url;

                if (fileUrl) {
                  fileUrl = `${getStrapiCdnUrl()}${fileUrl}`;
                }

                modifiedLinks.push({
                  href: fileUrl || link?.url || '',
                  label: link?.title,
                  download: !!fileUrl,
                });
              }

              links?.forEach(
                ({ file, title, url, formUid, defaultFormValues }: any) => {
                  let fileUrl = file.data?.attributes?.url;

                  if (fileUrl) {
                    fileUrl = `${getStrapiCdnUrl()}${fileUrl}`;
                  }

                  modifiedLinks.push({
                    href: fileUrl || url || '',
                    label: title,
                    download: !!fileUrl,
                    formUid,
                    defaultFormValues,
                  });
                },
              );

              return {
                image: img?.data?.attributes,
                title,
                description,
                links: modifiedLinks,
              };
            },
          )}
        />
      );
    case 'general.model-header':
      return (
        <ModelsHeader
          lang={lang}
          title={item.title}
          slug={slug || ''}
          navigation={item.navigation.map(({ title, url }: any) => ({
            label: title,
            href: url,
          }))}
          buttons={item.buttons}
          translates={translates}
        />
      );
    case 'shared.cta-buttons':
      return (
        <CtaButtons
          border={item.hasBorder}
          links={await Promise.all(
            item.navigation.map(
              async ({ href: url, rawIcon, title, formUid }: any) => {
                const params: any = {
                  logo: rawIcon,
                  title,
                  url: url || '',
                  formUid,
                };

                if (formUid) {
                  try {
                    const form = await getStrapiForm({ formUid, lang });

                    params.formData = form.data[0].attributes;
                  } catch (e) {}
                }

                return params;
              },
            ),
          )}
        />
      );
    case 'general.offer-banner':
      return (
        <OfferBanner
          key={key}
          cmsName={item.name}
          data={formatTime(pageUpdatedAt)}
          title={item.title}
          description={item.description}
          img={item.banner.data.attributes}
          mobileImg={item.mobileBanner.data.attributes}
          lightColorInDesktop={item.lightColorInDesktop}
          caption={item.caption}
          secondCaption={item.secondCaption}
          formUid={item.formUid}
          lang={lang}
          defaultFormValues={item.defaultFormValues}
        />
      );
    case 'general.technical-info':
      return (
        <TechnicalInfo
          sectionId={item.sectionId}
          key={key}
          title={item.title}
          description={item.description}
          img={item.banner.data.attributes}
          items={item.infoItems}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.text-content':
      return <TextContent key={key} content={item.content} />;
    case 'general.not-found':
      return (
        <NotFound
          buttonText={item.buttonText}
          img={item.img.data.attributes}
          lang={lang}
          title={item.title}
          description={item.description}
        />
      );
    case 'general.about-banner':
      return (
        <AboutBanner
          key={key}
          description={item.description}
          title={item.title}
          subtitle={item.subtitle}
          image={item.image?.data?.attributes}
          mobileImage={item.mobileImage?.data?.attributes}
          video={{
            url:
              item.videoUrl ||
              (item.video?.data?.attributes.url &&
                getStrapiMedia(item.video.data.attributes.url)),
          }}
        />
      );
    case 'general.about-discover':
      return (
        <AboutDiscover
          key={key}
          title={item.title}
          description={item.description}
          image={item.image?.data?.attributes}
          items={item.items}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.about-numbers':
      return (
        <AboutNumbers
          key={key}
          title={item.title}
          items={item.items}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.offers':
      const offersPage = searchParams[PAGE_KEY] || '1';
      let mainOffer = item.mainOffer?.data?.attributes || null;

      const offers = item.limitPerPage
        ? await getStrapiContent({
            url: `/api/offers?locale=${lang}&sort[0]=updatedAt:desc&publicationState=live&populate=deep&pagination[page]=${offersPage}&filters[slug][$not]=${
              mainOffer?.slug || ''
            }&filters[$or][0][validUntil][$notNull]&filters[$or][1][validUntil][$gt]=${new Date().toISOString()}&pagination[pageSize]=${
              item.limitPerPage
            }`,
          })
        : [];

      if (mainOffer?.validUntil) {
        if (new Date(mainOffer.validUntil) < new Date()) {
          mainOffer = null;
        }
      }

      if (offersPage !== '1') {
        mainOffer = null;
      }

      const offersCards = offers.data.map(({ attributes }: any) => ({
        ...attributes,
      }));

      const offersTotalPages =
        Math.ceil(offers?.meta?.pagination?.total / item.limitPerPage) || 0;

      return (
        <Offers
          key={key}
          title={item.title}
          lang={lang}
          mainOffer={mainOffer}
          cards={offersCards}
          emptyState={item.emptyState}
          translates={translates}
          currentPage={+offersPage}
          totalPages={+offersTotalPages}
          prefix={`/${lang}/offers`}
          searchParams={searchParams}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.advantages':
      return (
        <Advantages
          key={key}
          title={item.title}
          description={item.description}
          banner={item.banner?.data?.attributes}
          mobileBanner={item.mobileBanner?.data?.attributes}
          items={item.items}
          lang={lang}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.cta-banner':
      return (
        <CtaBanner
          key={key}
          title={item.title}
          caption={item.caption}
          description={item.description}
          banner={item.banner?.data?.attributes}
          mobileBanner={item.mobileBanner?.data?.attributes}
          link={item.link}
          lang={lang}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'general.careers-banner':
      return (
        <CareersBanner
          key={key}
          caption={item.caption}
          title={item.title}
          description={item.description}
          formUid={item.formUid}
          lang={lang}
          defaultFormValues={item.defaultFormValues}
        />
      );
    case 'general.news':
      const newsPage = searchParams[PAGE_KEY] || '1';
      let mainArticle =
        (!(
          searchParams?.[COUNTRY_KEY] ||
          searchParams?.[CATEGORY_KEY] ||
          searchParams?.[SEARCH_KEY]
        ) &&
          item.mainArticle?.data?.attributes) ||
        null;

      const articles = item.limitPerPage
        ? await getStrapiContent({
            url: `/api/articles?locale=${lang}&publicationState=live&sort[0]=updatedAt:desc&populate=deep&pagination[page]=${newsPage}&pagination[pageSize]=${
              item.limitPerPage
            }${
              mainArticle
                ? `&filters[slug][$not]=${mainArticle.slug || ''}`
                : ''
            }${
              searchParams?.[COUNTRY_KEY]
                ? `&filters[countries][code][$eq]=${searchParams?.[COUNTRY_KEY]}`
                : ''
            }${
              searchParams?.[CATEGORY_KEY]
                ? `&filters[articleTags][name][$eq]=${searchParams?.[CATEGORY_KEY]}`
                : ''
            }${
              searchParams?.[SEARCH_KEY]
                ? `&filters[$or][0][previewTitle][$containsi]=${searchParams?.[SEARCH_KEY]}&filters[$or][1][previewDescription][$containsi]=${searchParams?.[SEARCH_KEY]}`
                : ''
            }`,
          })
        : [];

      const articleCards = articles.data?.map(({ attributes }: any) => ({
        ...attributes,
      }));

      if (newsPage !== '1') {
        mainArticle = null;
      }

      const newsTotalPages =
        Math.ceil(articles?.meta?.pagination?.total / item.limitPerPage) || 0;

      return (
        <News
          key={key}
          title={item.title}
          mainArticle={mainArticle}
          articles={articleCards}
          filters={filters}
          translates={translates}
          currentPage={+newsPage}
          totalPages={+newsTotalPages}
          prefix={`/${lang}/news`}
          searchParams={searchParams}
          internalSectionTitle={item.internalSectionTitle}
        />
      );
    case 'article.article-banner':
      return (
        <ArticleBanner
          key={key}
          title={item.title}
          subtitle={item.subtitle}
          img={item.img?.data?.attributes}
          mobileImg={item.mobileImg?.data?.attributes}
          data={pageUpdatedAt}
        />
      );
    case 'article.article-text':
      return <ArticleText key={key} text={item.text} />;
    case 'article.article-suggested':
      return (
        <ArticleSuggested
          key={key}
          items={item.articles?.data?.map(
            ({
              attributes: { previewTitle, previewImg, publishedAt, slug },
            }: any) => ({
              link: `/${lang}/news/${slug}`,
              img: previewImg?.data?.attributes,
              data: publishedAt,
              text: previewTitle,
            }),
          )}
        />
      );
    case 'article.article-media':
      return (
        <ArticleMedia
          key={key}
          caption={item.caption}
          images={item.images?.data
            ?.slice(0, 3)
            .map(({ attributes }: any) => attributes)}
          video={{
            url:
              item.videoUrl ||
              (item.video?.data?.attributes.url &&
                getStrapiMedia(item.video.data.attributes.url)),
            poster: item.videoPoster?.data?.attributes,
          }}
        />
      );
    case 'article.article-quote':
      return <ArticleQuote key={key} text={item.text} author={item.author} />;
    case 'article.article-offered':
      return (
        <ArticleOffered
          key={key}
          items={item.offered?.map((item: any) => ({
            title: item.title,
            caption: item.caption,
            url: `/${lang}${item.url}`,
            img: item.img?.data?.attributes,
          }))}
        />
      );
    case 'article.article-feature-slider':
      return (
        <ArticleFeatureSlider
          key={key}
          cards={item.slides?.map((item: any) => ({
            title: item.title,
            description: item.description,
            img: item.img?.data?.attributes,
          }))}
        />
      );
    case 'general.banner-with-iframe':
      return <BannerWithIframe key={key} {...item} />;
    case 'general.events':
      const eventsPage = searchParams[PAGE_KEY] || '1';

      let mainEvent =
        !(
          searchParams?.[COUNTRY_KEY] ||
          searchParams?.[CATEGORY_KEY] ||
          searchParams?.[SEARCH_KEY]
        ) && item.mainEvent?.data?.attributes
          ? {
              ...item.mainEvent.data.attributes,
              updatedAt: item.mainEvent.data.attributes.eventAt,
            }
          : null;

      const eventAtFilter = `&filters[$or][0][eventAt][$notNull]&filters[$or][1][eventAt][$gte]=${new Date().toISOString()}`;
      const sortFilter = `&sort[0]=eventAt:desc&sort[1]=updatedAt:desc`;
      const paginationFilter = `&pagination[page]=${eventsPage}&pagination[pageSize]=${item.limitPerPage}`;

      const events = item.limitPerPage
        ? await getStrapiContent({
            url: `/api/events?locale=${lang}${eventAtFilter}${sortFilter}${paginationFilter}&publicationState=live&populate=deep${
              mainEvent ? `&filters[slug][$not]=${mainEvent.slug || ''}` : ''
            }${
              searchParams?.[COUNTRY_KEY]
                ? `&filters[countries][code][$eq]=${searchParams?.[COUNTRY_KEY]}`
                : ''
            }${
              searchParams?.[CATEGORY_KEY]
                ? `&filters[eventTags][name][$eq]=${searchParams?.[CATEGORY_KEY]}`
                : ''
            }${
              searchParams?.[SEARCH_KEY]
                ? `&filters[$or][2][previewData][title][$containsi]=${searchParams?.[SEARCH_KEY]}&filters[$or][3][previewData][description][$containsi]=${searchParams?.[SEARCH_KEY]}`
                : ''
            }`,
          })
        : [];

      const eventsCards = events.data?.map(({ attributes }: any) => ({
        ...attributes,
        updatedAt: attributes.eventAt,
      }));

      if (mainEvent?.eventAt) {
        const plusOneDay = new Date(mainEvent?.eventAt);
        plusOneDay.setDate(plusOneDay.getDate() + 1);

        if (plusOneDay < new Date()) {
          mainEvent = null;
        }
      }

      if (eventsPage !== '1') {
        mainEvent = null;
      }

      const eventsTotalPages =
        Math.ceil(events?.meta?.pagination?.total / item.limitPerPage) || 0;

      return (
        <Offers
          key={key}
          title={item.title}
          lang={lang}
          mainOffer={mainEvent}
          emptyState={item.emptyState}
          showData={true}
          cards={eventsCards}
          filters={filters}
          translates={translates}
          currentPage={+eventsPage}
          totalPages={+eventsTotalPages}
          prefix={`/${lang}/events`}
          searchParams={searchParams}
        />
      );

    case 'shared.cta-card':
      return (
        <CtaCard
          key={key}
          {...item}
          lang={lang}
          additionalStyle={{ margin: '40px 0 80px' }}
        />
      );
    case 'general.locations':
      return <Locations key={key} {...item} lang={lang} />;
    case 'general.image-section':
      return <ImageSection key={key} {...item} />;
    default:
      break;
  }
};

export default contentBuilder;
