import cn from 'classnames';

import { StrapiImageInterface } from '@/shared/ui/StrapiImage/index';
import Footer from '@/widgets/Footer/index';
import { Footer as IFooter } from '@/widgets/Footer/model/interface';
import Header from '@/widgets/Header/index';
import './index.scss';
import Script from 'next/script';
import { ScarabEventTracker } from '@/features/ScarabEventTracker';
import TimeOnPage from '@/features/TimeOnPage';
import TimeOnSection from '@/features/TimeOnSection';

const Layout = ({
  data,
  children,
  lang,
  models,
  type,
  locales,
  hideHeaderOnScroll,
  translates,
  hideLayout,
  offerTypeLayout,
  eventTypeLayout,
}: Readonly<{
  type?: 'dark' | 'light' | 'transparent';
  data: {
    locale: string;
    footer: IFooter;
    header: any;
    gtmId: string;
    googleTag: string;
    scarabId: string;
    emarsys?: {
      applicationCode: string;
      applicationServerPublicKey: string;
      notificationTitle: string;
    };
    gigyaApiKey?: string;
  };
  models: {
    slug: string;
    img: StrapiImageInterface;
    name: string;
    title: string;
    description: string;
    productName: string;
    formValue: string;
  }[];
  hideLayout: boolean;
  locales: string[];
  lang: string;
  children: React.ReactNode;
  hideHeaderOnScroll?: boolean;
  translates: { [key: string]: string };
  offerTypeLayout?: boolean;
  eventTypeLayout?: boolean;
}>) => {
  return (
    <>
      {data?.gtmId && (
        <noscript
          dangerouslySetInnerHTML={{
            __html: `<iframe src="https://www.googletagmanager.com/ns.html?id=${data.gtmId}" height="0" width="0" style="display:none;visibility:hidden"></iframe>`,
          }}
        ></noscript>
      )}

      <Script
        id="delayedScripts"
        strategy="afterInteractive"
        dangerouslySetInnerHTML={{
          __html: `(function() {
                      setTimeout(initGtm, 4000);

                      document.addEventListener('scroll', initGtmOnEvent);
                      document.addEventListener('mousemove', initGtmOnEvent);
                      document.addEventListener('touchstart', initGtmOnEvent);

                      function initGtmOnEvent(event) {
                        initGtm();
                        event.currentTarget.removeEventListener(event.type, initGtmOnEvent);
                      }

                      function initGtm() {
                        if (window.scriptsInit) {
                            return false;
                        }
            
                        window.scriptsInit = true;

                        ${
                          data?.gtmId
                            ? `(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
                                })(window,document,'script','dataLayer', '${data.gtmId}');`
                            : ''
                        }

                         ${
                           data?.googleTag
                             ? `window.dataLayer = window.dataLayer || [];
                              function gtag(){
                                dataLayer.push(arguments);
                              };
                              gtag('js', '${new Date()}');
                              gtag('config', '${data.googleTag}');

                              (function(id) {
                                if (document.getElementById(id)) return;
                                var js = document.createElement('script'); js.id = id;
                                js.src = 'https://www.googletagmanager.com/gtag/js?id=${
                                  data.googleTag
                                }';
                                var fs = document.getElementsByTagName('script')[0];
                                fs.parentNode.insertBefore(js, fs);
                                })('googleTag');
                                `
                             : ''
                         }

                        ${
                          data?.scarabId
                            ? `
                              window.ScarabQueue = window.ScarabQueue || [];
                              (function(id) {
                                if (document.getElementById(id)) return;
                                var js = document.createElement('script'); js.id = id;
                                js.src = '//cdn.scarabresearch.com/js/${data.scarabId}/scarab-v2.js';
                                var fs = document.getElementsByTagName('script')[0];
                                fs.parentNode.insertBefore(js, fs);
                                })('scarab-js-api');`
                            : ''
                        }

                        ${
                          data?.gigyaApiKey
                            ? `var __gigyaConf = {
                                onGigyaServiceReady: function () { 
                                    gigya.accounts.addEventHandlers({
                                        onLogin: function(r) {
                                            // User is logged in
                                        },
                                        onLogout: function(r) {
                                            // User is logged out
                                        }
                                    });
                                    gigya.accounts.session.verify({callback:function(response) {
                                            if(response.errorCode == 0) {
                                                    gigya.accounts.showScreenSet({screenSet:'Default-ProfileUpdate'});
                                            } else {
                                                    gigya.accounts.showScreenSet({screenSet:'Default-RegistrationLogin'});
                                            }
                                    }});
                                }
                              };
                              
                              (function(id) {
                                if (document.getElementById(id)) return;
                                var js = document.createElement('script'); js.id = id;
                                js.src = 'https://cdns.gigya.com/JS/gigya.js?apiKey=${data.gigyaApiKey}';
                                var fs = document.getElementsByTagName('script')[0];
                                fs.parentNode.insertBefore(js, fs);
                                })('gigya-js');`
                            : ''
                        }
                      }
                    })();`,
        }}
      />

      {data?.emarsys?.applicationCode &&
        data?.emarsys?.applicationServerPublicKey && (
          <>
            <Script
              id="emarsysWebSdk"
              strategy="beforeInteractive"
              src="https://client-version.cf.emarsys.net/web-emarsys-sdk-v4/latest/web-emarsys-sdk.js"
            />
            <Script
              id="emarsysWebSdkInit"
              strategy="afterInteractive"
              dangerouslySetInnerHTML={{
                __html: ` 
                event = new CustomEvent("loadedEmarsys");
                var WebEmarsysSdk = WebEmarsysSdk || []
                WebEmarsysSdk.push(['init', {
                  applicationCode:'${data.emarsys.applicationCode}',
                  defaultNotificationTitle: '${
                    data.emarsys.notificationTitle || ''
                  }', 
                  defaultNotificationIcon: '${
                    process.env.FRONTEND_HOST
                  }/android-chrome-192x192.png', 
                  autoSubscribe: false, 
                  serviceWorker: {
                    url: 'service-worker.js',
                    applicationServerPublicKey: '${
                      data.emarsys.applicationServerPublicKey
                    }'
                    }
                  }
                ]);
                setTimeout(()=>{
                  window.dispatchEvent(event);
                }, 3500)
              `,
              }}
            />
          </>
        )}
      <ScarabEventTracker />
      <TimeOnPage />
      <TimeOnSection />
      {!hideLayout ? (
        <>
          <Header
            locales={locales}
            lang={lang}
            data={data?.header}
            translates={translates}
            models={models}
            type={type}
            hideHeaderOnScroll={hideHeaderOnScroll}
            offerTypeLayout={offerTypeLayout}
            eventTypeLayout={eventTypeLayout}
          />
          <main
            className={cn({ 'main_no-padding-top': type === 'transparent' })}
          >
            {children}
          </main>
          {data?.footer && !offerTypeLayout && !eventTypeLayout && (
            <Footer lang={lang} data={data?.footer} />
          )}
        </>
      ) : (
        <>{children}</>
      )}
    </>
  );
};

export default Layout;
