/** @type {import('next').NextConfig} */

const nextConfig = {
  //   output: "export",
  trailingSlash: false,
  assetPrefix: process.env.NEXT_PUBLIC_NEXTJS_CDN_HOST,
  sassOptions: {
    includePaths: ['./src/app/styles'],
    additionalData: ` @import "@styles/config/index.scss";
                 `,
  },
  images: {
    remotePatterns: [
      {
        protocol: 'http',
        hostname: 'localhost',
        port: '1337',
        pathname: '**',
      },
      { hostname: 'staging.admin.cheryksa.estr.xyz' },
      {
        hostname: `${process.env.NEXT_PUBLIC_STRAPI_HOST}`
          .replace('https://', '')
          .replace('http://'),
        pathname: '**',
      },
    ],
  },
  redirects: async () => {
    return [
      {
        source: '/',
        destination: '/ar',
        permanent: true,
      },
    ];
  },
};

export default nextConfig;
