import { getStrapiContent } from '@/app/lib/utils';

export const revalidate = 3600;

export async function GET() {
  const [pages, offers, products, articles, events] = await Promise.all([
    getStrapiContent({
      url: '/api/pages?locale=all&publicationState=live&filters[showInSitemap][$eq]=true',
    }),
    getStrapiContent({
      url: '/api/offers?locale=all&publicationState=live&filters[showInSitemap][$eq]=true',
    }),
    getStrapiContent({
      url: '/api/products?locale=all&publicationState=live&filters[showInSitemap][$eq]=true',
    }),
    getStrapiContent({
      url: '/api/articles?locale=all&publicationState=live&filters[showInSitemap][$eq]=true',
    }),
    getStrapiContent({
      url: '/api/events?locale=all&publicationState=live&filters[showInSitemap][$eq]=true',
    }),
  ]);

  const sortPages = (array: any) => {
    return (array || []).reduce((acc: any, { attributes }: any) => {
      return {
        ...acc,
        [attributes.slug]: [...(acc[attributes.slug] || []), attributes.locale],
      };
    }, {});
  };
  const defaultLocale = 'ar';
  const siteUrl = process.env.FRONTEND_HOST;

  const urls = ({ pages, prefix }: any) => {
    return Object.entries(pages || {}).reduce(
      (acc: any, [cmsSlug, locales]: any) => {
        const hasDefaultLocale = locales.includes(defaultLocale);
        let slug = cmsSlug;

        if (slug === 'home-page') {
          slug = '';
        } else {
          slug = prefix + '/' + slug;
        }

        const alternate = locales.reduce((acc: any, locale: any) => {
          const href = `${siteUrl}/${locale}${slug}`;
          let str = `<xhtml:link rel="alternate" hreflang="${locale}" href="${href}" />`;
          return `${acc} ${str}`;
        }, '');

        const defaultAlternate = hasDefaultLocale
          ? `<xhtml:link rel="alternate" hreflang="x-default" href="${`${siteUrl}/${defaultLocale}${slug}`}" />`
          : '';

        return `${acc} ${locales.reduce(
          (acc: any, locale: any) =>
            `${acc} <url>
                        <loc>${siteUrl}/${locale}${slug}</loc>
                        ${alternate}
                        ${defaultAlternate}
                      </url>`,
          '',
        )}
        `;
      },
      '',
    );
  };

  const xmlContent = `<?xml version="1.0" encoding="UTF-8"?>
  <urlset
    xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9
                        http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd
                        http://www.w3.org/TR/xhtml11/xhtml11_schema.html
                        http://www.w3.org/2002/08/xhtml/xhtml1-strict.xsd"
    xmlns:xhtml="http://www.w3.org/TR/xhtml11/xhtml11_schema.html"
    xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
    xmlns:mobile="http://www.google.com/schemas/sitemap-mobile/1.0"
    xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
    xmlns:video="http://www.google.com/schemas/sitemap-video/1.1">

    ${urls({ pages: sortPages(pages.data), prefix: '' })}
    ${urls({ pages: sortPages(offers.data), prefix: '/offers' })}
    ${urls({ pages: sortPages(products.data), prefix: '/models' })}
    ${urls({ pages: sortPages(articles.data), prefix: '/news' })}
    ${urls({ pages: sortPages(events.data), prefix: '/events' })}
    
    </urlset>`;

  return new Response(xmlContent, {
    headers: { 'Content-Type': 'application/xml' },
  });
}
