import { NextResponse } from 'next/server';
import { getOAuth2Token } from '@/app/lib/get-oauth2-token';
import { CDP_API_INTEGRATION } from '@/app/lib/constants';

export async function POST(req: Request) {
  const body = await req.json();
  const { url: reqUrl, data, headers } = body;

  let url = reqUrl;

  try {
    if (url === CDP_API_INTEGRATION) {
      console.log('Requesting OAuth2 token for CDP API');
      const tokenUrl = String(process.env.CDP_API_OAUTH_TOKEN_URL);
      const clientId = String(process.env.CDP_API_CLIENT_ID);
      const clientSecret = String(process.env.CDP_API_CLIENT_SECRET);

      console.log('*** Credentials', {
        tokenUrl,
        clientId,
        clientSecret,
      });

      const token = await getOAuth2Token(tokenUrl, clientId, clientSecret);
      headers['Authorization'] = `Bearer ${token}`;

      url = process.env.CDP_API_LEAD_FORM_ENDPOINT_URL;
    }

    const res = await fetch(url, {
      method: 'POST',
      headers,
      body: JSON.stringify(data),
    });

    const contentType = res.headers.get('content-type');
    let response = {};

    if (!res.ok) {
      throw new Error('Request failed');
    }

    if (contentType?.includes('application/json')) {
      response = await res.json();
    } else if (contentType?.includes('text/html')) {
      response = await res.text();
    } else {
      response = 'ok';
    }

    console.log('Response:', response);

    return NextResponse.json({ response });
  } catch (error: any) {
    console.error('Error:', error.message);
    return NextResponse.json({ message: 'Server error' });
  }
}
