import {
  SEND_FORMDATA_ENDPOINT,
  SEND_FORMDATA_HEADERS,
} from '@/app/lib/constants';
import { NextResponse } from 'next/server';

export async function POST(req: Request) {
  const body = await req.formData();

  let url = '';
  let headers = {};

  try {
    url = body.get(SEND_FORMDATA_ENDPOINT) as string;
    body.delete(SEND_FORMDATA_ENDPOINT);
  } catch (e) {}

  try {
    headers = JSON.parse(body.get(SEND_FORMDATA_HEADERS) as any);
    body.delete(SEND_FORMDATA_HEADERS);
  } catch (e) {}

  try {
    const res = await fetch(url as string, {
      method: 'POST',
      headers,
      body,
    });

    const contentType = res.headers.get('content-type');
    let response = {};

    if (contentType?.includes('application/json')) {
      response = await res.json();
    } else if (contentType?.includes('text/html')) {
      response = await res.text();
    } else {
      response = 'ok';
    }

    return NextResponse.json({ response });
  } catch (e) {
    console.log(e);

    return NextResponse.json({ message: 'Server error' });
  }
}
