const express = require("express");
const bodyParser = require("body-parser");
const handler = require("./handler");

const app = express();
app.use(bodyParser.json());

app.post("/logs", async (req, res) => {
  try {
    const requestBody = req.body;
    await handler(requestBody);
    res.status(200).send();
  } catch (error) {
    console.error(error);
    res.status(500).send();
  }
});

app.get("/health", (req, res) => {
  res.send("alive");
});

const PORT = process.env.PORT || 3020;
app.listen(PORT, () => {
  console.log(`Server running on port ${PORT}`);
});
