import type { Schema, Attribute } from "@strapi/strapi";

export interface SharedSocialItem extends Schema.Component {
  collectionName: "components_shared_social_items";
  info: {
    displayName: "Social Item";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    href: Attribute.String;
    rawIcon: Attribute.Text;
  };
}

export interface SharedSeo extends Schema.Component {
  collectionName: "components_shared_seos";
  info: {
    displayName: "seo";
    icon: "search";
    description: "";
  };
  attributes: {
    metaTitle: Attribute.String;
    metaDescription: Attribute.String;
    metaImage: Attribute.Media<"images" | "files" | "videos">;
    keywords: Attribute.Text;
    metaRobots: Attribute.String;
    canonicalURL: Attribute.String;
  };
}

export interface SharedPlayButtonVideo extends Schema.Component {
  collectionName: "components_shared_play_button_videos";
  info: {
    displayName: "playButtonVideo";
    description: "";
  };
  attributes: {
    text: Attribute.String;
    videoUrl: Attribute.String;
    video: Attribute.Media<"videos">;
    videoTitle: Attribute.Text;
  };
}

export interface SharedPhoneOptions extends Schema.Component {
  collectionName: "components_shared_phone_options";
  info: {
    displayName: "Phone Options";
    description: "";
  };
  attributes: {
    mask: Attribute.String & Attribute.Required;
  };
}

export interface SharedOption extends Schema.Component {
  collectionName: "components_shared_options";
  info: {
    displayName: "option";
  };
  attributes: {
    name: Attribute.String;
    value: Attribute.String;
  };
}

export interface SharedOffercard extends Schema.Component {
  collectionName: "components_shared_offercards";
  info: {
    displayName: "offer card";
    description: "";
  };
  attributes: {
    banner: Attribute.Media<"images"> & Attribute.Required;
    mobileBanner: Attribute.Media<"images"> & Attribute.Required;
    offer: Attribute.Relation<
      "shared.offercard",
      "oneToOne",
      "api::offer.offer"
    >;
  };
}

export interface SharedOfferPreviewData extends Schema.Component {
  collectionName: "components_shared_offer_preview_data";
  info: {
    displayName: "Offer Preview Data";
  };
  attributes: {
    title: Attribute.Text;
    description: Attribute.Text;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
  };
}

export interface SharedModelCtaCard extends Schema.Component {
  collectionName: "components_shared_model_cta_cards";
  info: {
    displayName: "Model Cta Card";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    file: Attribute.Media<"files", true>;
    link: Attribute.Component<"shared.link">;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    links: Attribute.Component<"shared.model-cta-card-link", true>;
  };
}

export interface SharedModelCtaCardLink extends Schema.Component {
  collectionName: "components_shared_model_cta_card_links";
  info: {
    displayName: "ModelCtaCardLink";
    description: "";
  };
  attributes: {
    file: Attribute.Media<"files">;
    title: Attribute.String;
    url: Attribute.Text;
    formUid: Attribute.String;
    defaultFormValues: Attribute.JSON;
  };
}

export interface SharedMetaSocial extends Schema.Component {
  collectionName: "components_shared_meta_socials";
  info: {
    displayName: "metaSocial";
    icon: "project-diagram";
  };
  attributes: {
    socialNetwork: Attribute.Enumeration<["Facebook", "Twitter"]> &
      Attribute.Required;
    title: Attribute.String &
      Attribute.Required &
      Attribute.SetMinMaxLength<{
        maxLength: 60;
      }>;
    description: Attribute.String &
      Attribute.Required &
      Attribute.SetMinMaxLength<{
        maxLength: 65;
      }>;
    image: Attribute.Media<"images" | "files" | "videos">;
  };
}

export interface SharedMenuItem extends Schema.Component {
  collectionName: "components_shared_menu_items";
  info: {
    displayName: "Menu Item";
  };
  attributes: {
    items: Attribute.Component<"shared.link", true>;
    title: Attribute.String;
  };
}

export interface SharedLongText extends Schema.Component {
  collectionName: "components_shared_long_texts";
  info: {
    displayName: "longText";
  };
  attributes: {
    text: Attribute.RichText;
  };
}

export interface SharedLocationTab extends Schema.Component {
  collectionName: "components_shared_location_tabs";
  info: {
    displayName: "location tab";
    description: "";
  };
  attributes: {
    card: Attribute.Component<"shared.location-card", true>;
    title: Attribute.String;
  };
}

export interface SharedLocationInfo extends Schema.Component {
  collectionName: "components_shared_location_infos";
  info: {
    displayName: "Location info";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    content: Attribute.String;
    type: Attribute.Enumeration<["email", "tel", "link"]> &
      Attribute.DefaultTo<"link">;
    formDefaultValues: Attribute.JSON;
    formUid: Attribute.String;
    hiddenFormFields: Attribute.JSON;
    mobileStyles: Attribute.Text;
    desktopStyles: Attribute.Text;
  };
}

export interface SharedLocationCard extends Schema.Component {
  collectionName: "components_shared_location_cards";
  info: {
    displayName: "location card";
  };
  attributes: {
    title: Attribute.String;
    subtitle: Attribute.String;
    description: Attribute.String;
    info: Attribute.Component<"shared.location-info", true>;
    button: Attribute.Component<"shared.location-info", true>;
  };
}

export interface SharedLink extends Schema.Component {
  collectionName: "components_shared_links";
  info: {
    displayName: "Link";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    url: Attribute.String;
    hideInDesktop: Attribute.Boolean & Attribute.DefaultTo<false>;
    hideInMobile: Attribute.Boolean & Attribute.DefaultTo<false>;
  };
}

export interface SharedImageTitleDescription extends Schema.Component {
  collectionName: "components_shared_image_title_descriptions";
  info: {
    displayName: "ImageTitleDescription";
  };
  attributes: {
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    title: Attribute.String;
    description: Attribute.String;
  };
}

export interface SharedHeader extends Schema.Component {
  collectionName: "components_shared_headers";
  info: {
    displayName: "Header";
  };
  attributes: {
    title: Attribute.String;
    navigation: Attribute.Component<"shared.link", true>;
    cta: Attribute.Component<"shared.cta-buttons">;
  };
}

export interface SharedFooter extends Schema.Component {
  collectionName: "components_shared_footers";
  info: {
    displayName: "Footer";
    description: "";
  };
  attributes: {
    socials: Attribute.Component<"shared.social-item", true>;
    logo: Attribute.Media<"images" | "files" | "videos" | "audios">;
    company: Attribute.Media<"images" | "files" | "videos" | "audios">;
    description: Attribute.RichText;
    legal: Attribute.Component<"shared.link", true>;
    copyright: Attribute.String;
    menus: Attribute.Component<"shared.menu-item", true>;
  };
}

export interface SharedEmptyOffersState extends Schema.Component {
  collectionName: "components_shared_empty_offers_states";
  info: {
    displayName: "EmptyOffersState";
  };
  attributes: {
    title: Attribute.Text;
    returnUrl: Attribute.Text;
    buttonText: Attribute.Text;
  };
}

export interface SharedCtaCard extends Schema.Component {
  collectionName: "components_shared_cta_cards";
  info: {
    displayName: "cta card";
    description: "";
  };
  attributes: {
    banner: Attribute.Media<"images">;
    mobileImage: Attribute.Media<"images">;
    button: Attribute.Component<"shared.button">;
    title: Attribute.String;
    description: Attribute.Text;
    internalSectionTitle: Attribute.String;
  };
}

export interface SharedCtaCardIcon extends Schema.Component {
  collectionName: "components_shared_cta_card_icons";
  info: {
    displayName: "CtaCardIcon";
    description: "";
  };
  attributes: {
    icon: Attribute.Media<"images">;
    title: Attribute.String;
    button: Attribute.Component<"shared.button">;
    rawIcon: Attribute.Text;
  };
}

export interface SharedCtaButtons extends Schema.Component {
  collectionName: "components_shared_cta_buttons";
  info: {
    displayName: "Cta Buttons";
    description: "";
  };
  attributes: {
    navigation: Attribute.Component<"shared.cta-buttons-item", true>;
    hasBorder: Attribute.Boolean;
  };
}

export interface SharedCtaButtonsItem extends Schema.Component {
  collectionName: "components_shared_shared_cta_button_items";
  info: {
    displayName: "Cta Buttons Item";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    href: Attribute.String;
    formUid: Attribute.String;
    rawIcon: Attribute.Text;
  };
}

export interface SharedCarouselData extends Schema.Component {
  collectionName: "components_shared_carousel_data";
  info: {
    displayName: "CarouselData";
    description: "";
  };
  attributes: {
    name: Attribute.String & Attribute.Required;
    title: Attribute.String & Attribute.Required;
    description: Attribute.String;
  };
}

export interface SharedButton extends Schema.Component {
  collectionName: "components_shared_buttons";
  info: {
    displayName: "button";
    description: "";
  };
  attributes: {
    formUid: Attribute.String;
    appearance: Attribute.Enumeration<["dark", "light"]> &
      Attribute.DefaultTo<"light">;
    url: Attribute.String;
    formDefaultValues: Attribute.JSON;
    text: Attribute.String;
    behavior: Attribute.Enumeration<["button", "link"]> &
      Attribute.DefaultTo<"button">;
    buttonSize: Attribute.Enumeration<["lg", "sm"]> & Attribute.DefaultTo<"lg">;
    hasBorder: Attribute.Boolean & Attribute.DefaultTo<false>;
    hiddenFormFields: Attribute.JSON;
  };
}

export interface SharedAdvantageItemLink extends Schema.Component {
  collectionName: "components_shared_advantage_item_links";
  info: {
    displayName: "AdvantageItemLink";
  };
  attributes: {
    text: Attribute.String;
    url: Attribute.String;
    formUid: Attribute.String;
    formDefaultValues: Attribute.JSON;
  };
}

export interface SharedAdvantageItemIcon extends Schema.Component {
  collectionName: "components_shared_advantage_item_icons";
  info: {
    displayName: "AdvantageItemIcon";
    description: "";
  };
  attributes: {
    title: Attribute.Text;
    description: Attribute.Text;
    icon: Attribute.Media<"images">;
    rawIcon: Attribute.Text;
    link: Attribute.Component<"shared.advantage-item-link">;
  };
}

export interface SharedAboutNumberItem extends Schema.Component {
  collectionName: "components_shared_about_number_items";
  info: {
    displayName: "AboutNumberItem";
  };
  attributes: {
    title: Attribute.String;
    value: Attribute.String;
    description: Attribute.Text;
  };
}

export interface GeneralTextOverImage extends Schema.Component {
  collectionName: "components_general_text_over_images";
  info: {
    displayName: "Text Over Image";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    type: Attribute.Enumeration<["centered", "top"]>;
    sectionId: Attribute.String;
    desktopType: Attribute.Enumeration<["left", "centered"]>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralTextContent extends Schema.Component {
  collectionName: "components_general_text_contents";
  info: {
    displayName: "TextContent";
  };
  attributes: {
    content: Attribute.RichText;
  };
}

export interface GeneralTestimonials extends Schema.Component {
  collectionName: "components_general_testimonials";
  info: {
    displayName: "Testimonials";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    testimonials: Attribute.Relation<
      "general.testimonials",
      "oneToMany",
      "api::testimonial.testimonial"
    >;
    sectionId: Attribute.String;
    title: Attribute.RichText;
  };
}

export interface GeneralTechnicalInfo extends Schema.Component {
  collectionName: "components_general_technical_infos";
  info: {
    displayName: "Technical Info";
    description: "";
  };
  attributes: {
    title: Attribute.RichText;
    banner: Attribute.Media<"images">;
    mobileBanner: Attribute.Media<"images">;
    infoItems: Attribute.Component<"shared.option", true>;
    description: Attribute.Text;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralOffers extends Schema.Component {
  collectionName: "components_general_offers";
  info: {
    displayName: "Offers";
    description: "";
  };
  attributes: {
    mainOffer: Attribute.Relation<
      "general.offers",
      "oneToOne",
      "api::offer.offer"
    >;
    title: Attribute.String;
    limitPerPage: Attribute.Integer;
    emptyState: Attribute.Component<"shared.empty-offers-state">;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralOfferBanner extends Schema.Component {
  collectionName: "components_general_offer_banners";
  info: {
    displayName: "Offer Banner";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    lightColorInDesktop: Attribute.Boolean & Attribute.DefaultTo<false>;
    banner: Attribute.Media<"images">;
    mobileBanner: Attribute.Media<"images">;
    caption: Attribute.RichText;
    formUid: Attribute.String;
    defaultFormValues: Attribute.JSON;
    description: Attribute.RichText;
    secondCaption: Attribute.RichText;
  };
}

export interface GeneralNotFound extends Schema.Component {
  collectionName: "components_general_not_founds";
  info: {
    displayName: "Not found";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    description: Attribute.Text;
    buttonText: Attribute.String & Attribute.Required;
  };
}

export interface GeneralNews extends Schema.Component {
  collectionName: "components_general_news";
  info: {
    displayName: "News";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    limitPerPage: Attribute.Integer;
    mainArticle: Attribute.Relation<
      "general.news",
      "oneToOne",
      "api::article.article"
    >;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralModelsSlider extends Schema.Component {
  collectionName: "components_general_models_sliders";
  info: {
    displayName: "Models Slider";
    description: "";
  };
  attributes: {
    sectionId: Attribute.String;
    testDriveForm: Attribute.String;
  };
}

export interface GeneralModelHeader extends Schema.Component {
  collectionName: "components_general_model_headers";
  info: {
    displayName: "Model Header";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    navigation: Attribute.Component<"shared.link", true>;
    buttons: Attribute.Component<"shared.button", true>;
  };
}

export interface GeneralModelCtaGroup extends Schema.Component {
  collectionName: "components_general_model_cta_groups";
  info: {
    displayName: "Model Cta Group";
  };
  attributes: {
    cards: Attribute.Component<"shared.model-cta-card", true>;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralModelBanner extends Schema.Component {
  collectionName: "components_general_model_banners";
  info: {
    displayName: "Model Banner";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    sectionId: Attribute.String;
    playVideoButton: Attribute.Component<"shared.play-button-video">;
    additionalTitle: Attribute.Text;
    additionalDescription: Attribute.Text;
    additionalButton: Attribute.Component<"shared.model-cta-card-link">;
  };
}

export interface GeneralImageWithCarousel extends Schema.Component {
  collectionName: "components_general_image_with_carousels";
  info: {
    displayName: "Image With Carousel";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
  };
}

export interface GeneralImageSection extends Schema.Component {
  collectionName: "components_general_image_sections";
  info: {
    displayName: "ImageSection";
    description: "";
  };
  attributes: {
    desktopImage: Attribute.Media<"images" | "files" | "videos" | "audios">;
    mobileImage: Attribute.Media<"images" | "files" | "videos" | "audios">;
    desktopImageAspectRatio: Attribute.String & Attribute.DefaultTo<"1440/445">;
    mobileImageAspectRatio: Attribute.String & Attribute.DefaultTo<"375/200">;
    sectionStyles: Attribute.Text;
    hideImageInMobile: Attribute.Boolean & Attribute.DefaultTo<false>;
    hideImageInDesktop: Attribute.Boolean & Attribute.DefaultTo<false>;
    fullWidth: Attribute.Boolean & Attribute.DefaultTo<false>;
  };
}

export interface GeneralFeaturedProduct extends Schema.Component {
  collectionName: "components_general_featured_products";
  info: {
    displayName: "Featured Product";
    description: "";
  };
  attributes: {
    product: Attribute.Relation<
      "general.featured-product",
      "oneToOne",
      "api::product.product"
    >;
    image: Attribute.Media<"images"> & Attribute.Required;
    caption: Attribute.String;
    title: Attribute.String;
    sectionId: Attribute.String;
    titleType: Attribute.Enumeration<
      ["h1", "h2", "h3", "h4", "h5", "h6", "p", "span"]
    > &
      Attribute.DefaultTo<"h1">;
    mobileImage: Attribute.Media<"images">;
    buttons: Attribute.Component<"shared.button", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralEvents extends Schema.Component {
  collectionName: "components_general_events";
  info: {
    displayName: "Events";
    description: "";
  };
  attributes: {
    mainEvent: Attribute.Relation<
      "general.events",
      "oneToOne",
      "api::event.event"
    >;
    title: Attribute.Text;
    limitPerPage: Attribute.BigInteger;
    emptyState: Attribute.Component<"shared.empty-offers-state">;
  };
}

export interface GeneralEmarsys extends Schema.Component {
  collectionName: "components_general_emarsys";
  info: {
    displayName: "emarsys";
  };
  attributes: {
    notificationTitle: Attribute.Text;
    applicationCode: Attribute.Text & Attribute.Required;
    applicationServerPublicKey: Attribute.Text & Attribute.Required;
  };
}

export interface GeneralDealerCta extends Schema.Component {
  collectionName: "components_general_dealer_ctas";
  info: {
    displayName: "Dealer Cta";
  };
  attributes: {
    ctacards: Attribute.Component<"shared.cta-card-icon", true>;
    offercards: Attribute.Component<"shared.offercard", true>;
    ctacard: Attribute.Component<"shared.cta-card">;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralCtaBanner extends Schema.Component {
  collectionName: "components_general_cta_banners";
  info: {
    displayName: "CtaBanner";
  };
  attributes: {
    title: Attribute.RichText;
    description: Attribute.Text;
    caption: Attribute.String;
    banner: Attribute.Media<"images"> & Attribute.Required;
    mobileBanner: Attribute.Media<"images", true>;
    link: Attribute.Component<"shared.link">;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralCareersBanner extends Schema.Component {
  collectionName: "components_general_careers_banners";
  info: {
    displayName: "Careers Banner";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    title: Attribute.RichText;
    formUid: Attribute.String;
    formDefaultValues: Attribute.JSON;
    description: Attribute.RichText;
  };
}

export interface GeneralBrochureSlider extends Schema.Component {
  collectionName: "components_general_brochure_sliders";
  info: {
    displayName: "Brochure Slider";
  };
  attributes: {
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
  };
}

export interface GeneralBodyCopySliderWithLabel extends Schema.Component {
  collectionName: "components_general_body_copy_slider_with_labels";
  info: {
    displayName: "Body Copy Slider With Label";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralBannerWithIframe extends Schema.Component {
  collectionName: "components_general_banner_with_iframes";
  info: {
    displayName: "BannerWithIframe";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    title: Attribute.RichText;
    description: Attribute.Text;
    iframeSrc: Attribute.Text;
    desktopTextMaxWidth: Attribute.String;
    mobileTextMaxWidth: Attribute.String;
  };
}

export interface GeneralAdvantages extends Schema.Component {
  collectionName: "components_general_advantages";
  info: {
    displayName: "Advantages";
  };
  attributes: {
    title: Attribute.RichText;
    description: Attribute.Text;
    banner: Attribute.Media<"images"> & Attribute.Required;
    mobileBanner: Attribute.Media<"images">;
    items: Attribute.Component<"shared.advantage-item-icon", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutNumbers extends Schema.Component {
  collectionName: "components_general_about_numbers";
  info: {
    displayName: "AboutNumbers";
    description: "";
  };
  attributes: {
    title: Attribute.Text;
    items: Attribute.Component<"shared.about-number-item", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutDiscover extends Schema.Component {
  collectionName: "components_general_about_discovers";
  info: {
    displayName: "AboutDiscover";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    image: Attribute.Media<"images">;
    items: Attribute.Component<"shared.long-text", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutBanner extends Schema.Component {
  collectionName: "components_general_about_banners";
  info: {
    displayName: "AboutBanner";
    description: "";
  };
  attributes: {
    subtitle: Attribute.String;
    image: Attribute.Media<"images">;
    mobileImage: Attribute.Media<"images">;
    video: Attribute.Media<"videos">;
    videoUrl: Attribute.String;
    title: Attribute.String;
    description: Attribute.Text;
  };
}

export interface GeneralTextOverImage extends Schema.Component {
  collectionName: "components_general_text_over_images";
  info: {
    displayName: "Text Over Image";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    type: Attribute.Enumeration<["centered", "top"]>;
    sectionId: Attribute.String;
    desktopType: Attribute.Enumeration<["left", "centered"]>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralTextContent extends Schema.Component {
  collectionName: "components_general_text_contents";
  info: {
    displayName: "TextContent";
  };
  attributes: {
    content: Attribute.RichText;
  };
}

export interface GeneralTestimonials extends Schema.Component {
  collectionName: "components_general_testimonials";
  info: {
    displayName: "Testimonials";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    testimonials: Attribute.Relation<
      "general.testimonials",
      "oneToMany",
      "api::testimonial.testimonial"
    >;
    sectionId: Attribute.String;
    title: Attribute.RichText;
  };
}

export interface GeneralTechnicalInfo extends Schema.Component {
  collectionName: "components_general_technical_infos";
  info: {
    displayName: "Technical Info";
    description: "";
  };
  attributes: {
    title: Attribute.RichText;
    banner: Attribute.Media<"images">;
    mobileBanner: Attribute.Media<"images">;
    infoItems: Attribute.Component<"shared.option", true>;
    description: Attribute.Text;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralOffers extends Schema.Component {
  collectionName: "components_general_offers";
  info: {
    displayName: "Offers";
    description: "";
  };
  attributes: {
    mainOffer: Attribute.Relation<
      "general.offers",
      "oneToOne",
      "api::offer.offer"
    >;
    title: Attribute.String;
    limitPerPage: Attribute.Integer;
    emptyState: Attribute.Component<"shared.empty-offers-state">;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralOfferBanner extends Schema.Component {
  collectionName: "components_general_offer_banners";
  info: {
    displayName: "Offer Banner";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    lightColorInDesktop: Attribute.Boolean & Attribute.DefaultTo<false>;
    banner: Attribute.Media<"images">;
    mobileBanner: Attribute.Media<"images">;
    caption: Attribute.RichText;
    formUid: Attribute.String;
    defaultFormValues: Attribute.JSON;
    description: Attribute.RichText;
    secondCaption: Attribute.RichText;
  };
}

export interface GeneralNotFound extends Schema.Component {
  collectionName: "components_general_not_founds";
  info: {
    displayName: "Not found";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    description: Attribute.Text;
    buttonText: Attribute.String & Attribute.Required;
  };
}

export interface GeneralNews extends Schema.Component {
  collectionName: "components_general_news";
  info: {
    displayName: "News";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    limitPerPage: Attribute.Integer;
    mainArticle: Attribute.Relation<
      "general.news",
      "oneToOne",
      "api::article.article"
    >;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralModelsSlider extends Schema.Component {
  collectionName: "components_general_models_sliders";
  info: {
    displayName: "Models Slider";
    description: "";
  };
  attributes: {
    sectionId: Attribute.String;
    testDriveForm: Attribute.String;
  };
}

export interface GeneralModelHeader extends Schema.Component {
  collectionName: "components_general_model_headers";
  info: {
    displayName: "Model Header";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    navigation: Attribute.Component<"shared.link", true>;
    buttons: Attribute.Component<"shared.button", true>;
  };
}

export interface GeneralModelCtaGroup extends Schema.Component {
  collectionName: "components_general_model_cta_groups";
  info: {
    displayName: "Model Cta Group";
  };
  attributes: {
    cards: Attribute.Component<"shared.model-cta-card", true>;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralModelBanner extends Schema.Component {
  collectionName: "components_general_model_banners";
  info: {
    displayName: "Model Banner";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    sectionId: Attribute.String;
    playVideoButton: Attribute.Component<"shared.play-button-video">;
    additionalTitle: Attribute.Text;
    additionalDescription: Attribute.Text;
    additionalButton: Attribute.Component<"shared.model-cta-card-link">;
  };
}

export interface GeneralLocations extends Schema.Component {
  collectionName: "components_general_locations";
  info: {
    displayName: "Locations";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    cityFilterPlaceholder: Attribute.Text;
    tabs: Attribute.Component<"shared.location-tab", true>;
  };
}

export interface GeneralImageWithCarousel extends Schema.Component {
  collectionName: "components_general_image_with_carousels";
  info: {
    displayName: "Image With Carousel";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    img: Attribute.Media<"images">;
    mobileImg: Attribute.Media<"images">;
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
  };
}

export interface GeneralFeaturedProduct extends Schema.Component {
  collectionName: "components_general_featured_products";
  info: {
    displayName: "Featured Product";
    description: "";
  };
  attributes: {
    product: Attribute.Relation<
      "general.featured-product",
      "oneToOne",
      "api::product.product"
    >;
    image: Attribute.Media<"images"> & Attribute.Required;
    caption: Attribute.String;
    title: Attribute.String;
    sectionId: Attribute.String;
    titleType: Attribute.Enumeration<
      ["h1", "h2", "h3", "h4", "h5", "h6", "p", "span"]
    > &
      Attribute.DefaultTo<"h1">;
    mobileImage: Attribute.Media<"images">;
    buttons: Attribute.Component<"shared.button", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralEvents extends Schema.Component {
  collectionName: "components_general_events";
  info: {
    displayName: "Events";
    description: "";
  };
  attributes: {
    mainEvent: Attribute.Relation<
      "general.events",
      "oneToOne",
      "api::event.event"
    >;
    title: Attribute.Text;
    limitPerPage: Attribute.BigInteger;
    emptyState: Attribute.Component<"shared.empty-offers-state">;
  };
}

export interface GeneralEmarsys extends Schema.Component {
  collectionName: "components_general_emarsys";
  info: {
    displayName: "emarsys";
  };
  attributes: {
    notificationTitle: Attribute.Text;
    applicationCode: Attribute.Text & Attribute.Required;
    applicationServerPublicKey: Attribute.Text & Attribute.Required;
  };
}

export interface GeneralDealerCta extends Schema.Component {
  collectionName: "components_general_dealer_ctas";
  info: {
    displayName: "Dealer Cta";
  };
  attributes: {
    ctacards: Attribute.Component<"shared.cta-card-icon", true>;
    offercards: Attribute.Component<"shared.offercard", true>;
    ctacard: Attribute.Component<"shared.cta-card">;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralCtaBanner extends Schema.Component {
  collectionName: "components_general_cta_banners";
  info: {
    displayName: "CtaBanner";
  };
  attributes: {
    title: Attribute.RichText;
    description: Attribute.Text;
    caption: Attribute.String;
    banner: Attribute.Media<"images"> & Attribute.Required;
    mobileBanner: Attribute.Media<"images", true>;
    link: Attribute.Component<"shared.link">;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralCareersBanner extends Schema.Component {
  collectionName: "components_general_careers_banners";
  info: {
    displayName: "Careers Banner";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    title: Attribute.RichText;
    formUid: Attribute.String;
    formDefaultValues: Attribute.JSON;
    description: Attribute.RichText;
  };
}

export interface GeneralBrochureSlider extends Schema.Component {
  collectionName: "components_general_brochure_sliders";
  info: {
    displayName: "Brochure Slider";
  };
  attributes: {
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
  };
}

export interface GeneralBodyCopySliderWithLabel extends Schema.Component {
  collectionName: "components_general_body_copy_slider_with_labels";
  info: {
    displayName: "Body Copy Slider With Label";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.String;
    slides: Attribute.Component<"shared.image-title-description", true>;
    sectionId: Attribute.String;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralBannerWithIframe extends Schema.Component {
  collectionName: "components_general_banner_with_iframes";
  info: {
    displayName: "BannerWithIframe";
  };
  attributes: {
    caption: Attribute.String;
    title: Attribute.RichText;
    description: Attribute.Text;
    iframeSrc: Attribute.Text;
  };
}

export interface GeneralAdvantages extends Schema.Component {
  collectionName: "components_general_advantages";
  info: {
    displayName: "Advantages";
  };
  attributes: {
    title: Attribute.RichText;
    description: Attribute.Text;
    banner: Attribute.Media<"images"> & Attribute.Required;
    mobileBanner: Attribute.Media<"images">;
    items: Attribute.Component<"shared.advantage-item-icon", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutNumbers extends Schema.Component {
  collectionName: "components_general_about_numbers";
  info: {
    displayName: "AboutNumbers";
    description: "";
  };
  attributes: {
    title: Attribute.Text;
    items: Attribute.Component<"shared.about-number-item", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutDiscover extends Schema.Component {
  collectionName: "components_general_about_discovers";
  info: {
    displayName: "AboutDiscover";
    description: "";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    image: Attribute.Media<"images">;
    items: Attribute.Component<"shared.long-text", true>;
    internalSectionTitle: Attribute.String;
  };
}

export interface GeneralAboutBanner extends Schema.Component {
  collectionName: "components_general_about_banners";
  info: {
    displayName: "AboutBanner";
    description: "";
  };
  attributes: {
    subtitle: Attribute.String;
    image: Attribute.Media<"images">;
    mobileImage: Attribute.Media<"images">;
    video: Attribute.Media<"videos">;
    videoUrl: Attribute.String;
    title: Attribute.String;
    description: Attribute.Text;
  };
}

export interface FormText extends Schema.Component {
  collectionName: "components_form_texts";
  info: {
    displayName: "text";
    description: "";
  };
  attributes: {
    text: Attribute.String & Attribute.Required;
  };
}

export interface FormSwitcher extends Schema.Component {
  collectionName: "components_form_switchers";
  info: {
    displayName: "switcher";
    description: "";
  };
  attributes: {
    label: Attribute.String & Attribute.Required;
    name: Attribute.String & Attribute.Required;
    hint: Attribute.String;
    options: Attribute.Component<"shared.option", true> &
      Attribute.Required &
      Attribute.SetMinMax<
        {
          max: 2;
        },
        number
      >;
    selectedValue: Attribute.String & Attribute.Required;
  };
}

export interface FormSuccess extends Schema.Component {
  collectionName: "components_form_successes";
  info: {
    displayName: "success";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    description: Attribute.String;
    button: Attribute.Component<"form.success-action">;
  };
}

export interface FormSuccessAction extends Schema.Component {
  collectionName: "components_form_success_actions";
  info: {
    displayName: "successAction";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
  };
}

export interface FormSubmitAction extends Schema.Component {
  collectionName: "components_form_submit_actions";
  info: {
    displayName: "submitAction";
    description: "";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    endpoint: Attribute.String & Attribute.Required;
    hiddenFields: Attribute.JSON;
  };
}

export interface FormStepsInputs extends Schema.Component {
  collectionName: "components_form_steps_inputs";
  info: {
    displayName: "stepsInputs";
  };
  attributes: {
    backButton: Attribute.String;
    names: Attribute.Component<"form.text", true>;
    title: Attribute.RichText &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
    description: Attribute.RichText &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
    submit: Attribute.Component<"form.step-submit-action"> &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
    success: Attribute.Component<"form.success"> &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
  };
}

export interface FormStepSubmitAction extends Schema.Component {
  collectionName: "components_form_step_submit_actions";
  info: {
    displayName: "stepSubmitAction";
    description: "";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    endpoint: Attribute.String;
    names: Attribute.Component<"form.text", true>;
    hiddenFields: Attribute.JSON;
    caption: Attribute.RichText;
  };
}

export interface FormSelect extends Schema.Component {
  collectionName: "components_form_selects";
  info: {
    displayName: "select";
    description: "";
  };
  attributes: {
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
    placeholder: Attribute.String & Attribute.Required;
    label: Attribute.String & Attribute.Required;
    name: Attribute.String & Attribute.Required;
    options: Attribute.JSON & Attribute.Required;
    hint: Attribute.String;
  };
}

export interface FormRegex extends Schema.Component {
  collectionName: "components_form_regexes";
  info: {
    displayName: "Regex";
  };
  attributes: {
    regex: Attribute.String;
    message: Attribute.String;
  };
}

export interface FormPhoneInput extends Schema.Component {
  collectionName: "components_form_phone_inputs";
  info: {
    displayName: "Phone Input";
    description: "";
  };
  attributes: {
    name: Attribute.String & Attribute.Required;
    label: Attribute.String;
    hint: Attribute.String;
    options: Attribute.Component<"shared.phone-options", true> &
      Attribute.Required &
      Attribute.SetMinMax<
        {
          max: 1;
        },
        number
      >;
    placeholder: Attribute.String;
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
  };
}

export interface FormOtpInput extends Schema.Component {
  collectionName: "components_form_otp_inputs";
  info: {
    displayName: "Otp Input";
  };
  attributes: {
    codeLength: Attribute.Integer;
    name: Attribute.String;
    hint: Attribute.String &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
    required: Attribute.Boolean & Attribute.DefaultTo<true>;
    label: Attribute.String &
      Attribute.SetPluginOptions<{
        i18n: {
          localized: true;
        };
      }>;
  };
}

export interface FormInput extends Schema.Component {
  collectionName: "components_form_inputs";
  info: {
    displayName: "input";
    description: "";
  };
  attributes: {
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
    placeholder: Attribute.String & Attribute.Required;
    label: Attribute.String & Attribute.Required;
    name: Attribute.String & Attribute.Required;
    type: Attribute.Enumeration<["input", "textarea"]> &
      Attribute.DefaultTo<"input">;
    errors: Attribute.JSON;
    pattern: Attribute.Component<"form.regex">;
    hint: Attribute.String;
    maxLength: Attribute.BigInteger;
  };
}

export interface FormFormStep extends Schema.Component {
  collectionName: "components_form_form_steps";
  info: {
    displayName: "FormStep";
  };
  attributes: {
    backButton: Attribute.String;
    nextButton: Attribute.String;
    inputs: Attribute.Component<"form.steps-inputs", true>;
  };
}

export interface FormFileInput extends Schema.Component {
  collectionName: "components_form_file_inputs";
  info: {
    displayName: "File Input";
    description: "";
  };
  attributes: {
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
    name: Attribute.String & Attribute.Required;
    label: Attribute.String & Attribute.Required;
    placeholder: Attribute.String & Attribute.Required;
    hint: Attribute.String & Attribute.Required;
    fileSize: Attribute.BigInteger &
      Attribute.Required &
      Attribute.DefaultTo<"2">;
    extensions: Attribute.Component<"form.text", true> & Attribute.Required;
  };
}

export interface FormDatepicker extends Schema.Component {
  collectionName: "components_form_datepickers";
  info: {
    displayName: "datepicker";
    description: "";
  };
  attributes: {
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
    placeholder: Attribute.String & Attribute.Required;
    label: Attribute.String & Attribute.Required;
    name: Attribute.String & Attribute.Required;
    hint: Attribute.String;
  };
}

export interface FormCheckbox extends Schema.Component {
  collectionName: "components_form_checkboxes";
  info: {
    displayName: "checkbox";
    description: "";
  };
  attributes: {
    required: Attribute.Boolean &
      Attribute.Required &
      Attribute.DefaultTo<false>;
    name: Attribute.String & Attribute.Required;
    errors: Attribute.JSON;
    label: Attribute.RichText;
  };
}

export interface ArticleArticleText extends Schema.Component {
  collectionName: "components_article_article_texts";
  info: {
    displayName: "ArticleText";
  };
  attributes: {
    text: Attribute.RichText & Attribute.Required;
  };
}

export interface ArticleArticleSuggested extends Schema.Component {
  collectionName: "components_article_article_suggesteds";
  info: {
    displayName: "ArticleSuggested";
  };
  attributes: {
    articles: Attribute.Relation<
      "article.article-suggested",
      "oneToMany",
      "api::article.article"
    >;
  };
}

export interface ArticleArticleQuote extends Schema.Component {
  collectionName: "components_article_article_quotes";
  info: {
    displayName: "ArticleQuote";
    description: "";
  };
  attributes: {
    text: Attribute.Text & Attribute.Required;
    author: Attribute.String;
  };
}

export interface ArticleArticleOffered extends Schema.Component {
  collectionName: "components_article_article_offereds";
  info: {
    displayName: "ArticleOffered";
    description: "";
  };
  attributes: {
    title: Attribute.Text;
    offered: Attribute.Component<"article.article-offered-item", true>;
  };
}

export interface ArticleArticleOfferedItem extends Schema.Component {
  collectionName: "components_article_article_offered_items";
  info: {
    displayName: "ArticleOfferedItem";
    description: "";
  };
  attributes: {
    title: Attribute.String & Attribute.Required;
    caption: Attribute.String;
    img: Attribute.Media<"images"> & Attribute.Required;
    url: Attribute.String & Attribute.Required;
  };
}

export interface ArticleArticleMedia extends Schema.Component {
  collectionName: "components_article_article_medias";
  info: {
    displayName: "ArticleMedia";
    description: "";
  };
  attributes: {
    caption: Attribute.String;
    images: Attribute.Media<"images", true>;
    video: Attribute.Media<"videos">;
    videoUrl: Attribute.Text;
    videoPoster: Attribute.Media<"images">;
  };
}

export interface ArticleArticleFeatureSlider extends Schema.Component {
  collectionName: "components_article_article_feature_sliders";
  info: {
    displayName: "ArticleFeatureSlider";
  };
  attributes: {
    slides: Attribute.Component<"article.article-feature-slide", true>;
  };
}

export interface ArticleArticleFeatureSlide extends Schema.Component {
  collectionName: "components_article_article_feature_slides";
  info: {
    displayName: "ArticleFeatureSlide";
  };
  attributes: {
    title: Attribute.String;
    description: Attribute.Text;
    img: Attribute.Media<"images">;
  };
}

export interface ArticleArticleBanner extends Schema.Component {
  collectionName: "components_article_article_banners";
  info: {
    displayName: "ArticleBanner";
    description: "";
  };
  attributes: {
    subtitle: Attribute.Text;
    title: Attribute.RichText & Attribute.Required;
    img: Attribute.Media<"images"> & Attribute.Required;
    mobileImg: Attribute.Media<"images">;
  };
}

declare module "@strapi/types" {
  export module Shared {
    export interface Components {
      "shared.social-item": SharedSocialItem;
      "shared.seo": SharedSeo;
      "shared.play-button-video": SharedPlayButtonVideo;
      "shared.phone-options": SharedPhoneOptions;
      "shared.option": SharedOption;
      "shared.offercard": SharedOffercard;
      "shared.offer-preview-data": SharedOfferPreviewData;
      "shared.model-cta-card": SharedModelCtaCard;
      "shared.model-cta-card-link": SharedModelCtaCardLink;
      "shared.meta-social": SharedMetaSocial;
      "shared.menu-item": SharedMenuItem;
      "shared.long-text": SharedLongText;
      "shared.location-tab": SharedLocationTab;
      "shared.location-info": SharedLocationInfo;
      "shared.location-card": SharedLocationCard;
      "shared.link": SharedLink;
      "shared.image-title-description": SharedImageTitleDescription;
      "shared.header": SharedHeader;
      "shared.footer": SharedFooter;
      "shared.empty-offers-state": SharedEmptyOffersState;
      "shared.cta-card": SharedCtaCard;
      "shared.cta-card-icon": SharedCtaCardIcon;
      "shared.cta-buttons": SharedCtaButtons;
      "shared.cta-buttons-item": SharedCtaButtonsItem;
      "shared.carousel-data": SharedCarouselData;
      "shared.button": SharedButton;
      "shared.advantage-item-link": SharedAdvantageItemLink;
      "shared.advantage-item-icon": SharedAdvantageItemIcon;
      "shared.about-number-item": SharedAboutNumberItem;
      "general.text-over-image": GeneralTextOverImage;
      "general.text-content": GeneralTextContent;
      "general.testimonials": GeneralTestimonials;
      "general.technical-info": GeneralTechnicalInfo;
      "general.offers": GeneralOffers;
      "general.offer-banner": GeneralOfferBanner;
      "general.not-found": GeneralNotFound;
      "general.news": GeneralNews;
      "general.models-slider": GeneralModelsSlider;
      "general.model-header": GeneralModelHeader;
      "general.model-cta-group": GeneralModelCtaGroup;
      "general.model-banner": GeneralModelBanner;
      "general.locations": GeneralLocations;
      "general.image-with-carousel": GeneralImageWithCarousel;
      "general.image-section": GeneralImageSection;
      "general.featured-product": GeneralFeaturedProduct;
      "general.events": GeneralEvents;
      "general.emarsys": GeneralEmarsys;
      "general.dealer-cta": GeneralDealerCta;
      "general.cta-banner": GeneralCtaBanner;
      "general.careers-banner": GeneralCareersBanner;
      "general.brochure-slider": GeneralBrochureSlider;
      "general.body-copy-slider-with-label": GeneralBodyCopySliderWithLabel;
      "general.banner-with-iframe": GeneralBannerWithIframe;
      "general.advantages": GeneralAdvantages;
      "general.about-numbers": GeneralAboutNumbers;
      "general.about-discover": GeneralAboutDiscover;
      "general.about-banner": GeneralAboutBanner;
      "form.text": FormText;
      "form.switcher": FormSwitcher;
      "form.success": FormSuccess;
      "form.success-action": FormSuccessAction;
      "form.submit-action": FormSubmitAction;
      "form.steps-inputs": FormStepsInputs;
      "form.step-submit-action": FormStepSubmitAction;
      "form.select": FormSelect;
      "form.regex": FormRegex;
      "form.phone-input": FormPhoneInput;
      "form.otp-input": FormOtpInput;
      "form.input": FormInput;
      "form.form-step": FormFormStep;
      "form.file-input": FormFileInput;
      "form.datepicker": FormDatepicker;
      "form.checkbox": FormCheckbox;
      "article.article-text": ArticleArticleText;
      "article.article-suggested": ArticleArticleSuggested;
      "article.article-quote": ArticleArticleQuote;
      "article.article-offered": ArticleArticleOffered;
      "article.article-offered-item": ArticleArticleOfferedItem;
      "article.article-media": ArticleArticleMedia;
      "article.article-feature-slider": ArticleArticleFeatureSlider;
      "article.article-feature-slide": ArticleArticleFeatureSlide;
      "article.article-banner": ArticleArticleBanner;
    }
  }
}
