"use strict";

/**
 * product controller
 */

const { createCoreController } = require("@strapi/strapi").factories;

module.exports = createCoreController("api::product.product", ({ strapi }) => ({
  async findBySlug(ctx) {
    const { slug } = ctx.params;

    const query = {
      filters: { slug },
      ...ctx.query,
    };

    const post = await strapi.entityService.findMany(
      "api::product.product",
      query
    );

    return this.transformResponse(post[0]);
  },

  async search(ctx) {
    const { search } = ctx.params;

    const query = {
      filters: {
        name: { $containsi: search },
      },
      ...ctx.query,
    };

    const posts = await strapi.entityService.findMany(
      "api::product.product",
      query
    );

    return this.transformResponse(posts);
  },
}));
