"use strict";

/**
 * offer controller
 */

const { createCoreController } = require("@strapi/strapi").factories;

module.exports = createCoreController("api::offer.offer", ({ strapi }) => ({
  async findBySlug(ctx) {
    const { slug } = ctx.params;

    const query = {
      filters: { slug },
      ...ctx.query,
    };

    const offer = await strapi.entityService.findMany(
      "api::offer.offer",
      query
    );

    return this.transformResponse(offer[0]);
  },
}));
