"use strict";

/**
 * form controller
 */

const { createCoreController } = require("@strapi/strapi").factories;

module.exports = createCoreController("api::form.form", ({ strapi }) => ({
  async findByUid(ctx) {
    const { uid } = ctx.params;

    const query = {
      filters: { uid },
      ...ctx.query,
    };

    const form = await strapi.entityService.findMany("api::form.form", query);
    const sanitizedEntity = await this.sanitizeOutput(form);

    return this.transformResponse(form);
  },
}));
