module.exports = ({ env }) => ({
  "strapi-plugin-populate-deep": {
    config: {
      defaultDepth: 8,
    },
  },
  "preview-button": {
    config: {
      contentTypes: [
        {
          uid: "api::page.page",
          published: {
            url: process.env.FRONTEND_HOST + "/{locale}/{slug}",
            openTarget: "_blank",
          },
        },
        {
          uid: "api::offer.offer",
          published: {
            url: process.env.FRONTEND_HOST + "/{locale}/offers/{slug}",
            openTarget: "_blank",
          },
        },
        {
          uid: "api::product.product",
          published: {
            url: process.env.FRONTEND_HOST + "/{locale}/models/{slug}",
            openTarget: "_blank",
          },
        },
      ],
    },
  },
});
