Requirements
------------

Before you begin, ensure that the following software is installed on your system:

1.  **Docker & Docker Compose**: Used for creating isolated environments to run the app. Install from the [official Docker documentation](https://docs.docker.com/engine/install/).
2.  **NodeJS**: The JavaScript runtime environment that our app depends on. We recommend using [NVM](https://github.com/nvm-sh/nvm#install--update-script) to manage different Node.js versions seamlessly.

Setting Up The Application
--------------------------

Follow these steps to set up and run the app:

1.  **Clone the repository**: Use git to clone the repository to your local machine.
2.  **Build Docker containers**: Run `docker-compose build` from the root of the project directory to build Docker containers.
3.  **Set up the server**: Navigate to the "backend" directory, create a `.env` file from the `.env.example` and replace placeholders with actual values as needed.
4.  **Set up the client**: Navigate to the "frontend" directory and install dependencies with `yarn install`.
5.  **Update your hosts file**: Add an entry to your `/etc/hosts` file by running the following command:
   
```
sudo sh -c "echo '127.0.0.1 cheryksa.localhost' >> /etc/hosts"
```
   
Running The Application
-----------------------

To start the backend run the following command:

`docker-compose up -d`

To run the frontend development server, navigate to the "frontend" directory and execute the command below:

`yarn dev`

Once both the backend and frontend servers are running, you can access the application at http://cheryksa.localhost.
