import React from 'react';
import ReactDiffViewer, { DiffMethod } from 'react-diff-viewer-continued';
import { useIntl } from 'react-intl';

import {
  ModalLayout,
  ModalBody,
  ModalHeader,
  Grid,
  GridItem,
  Typography,
} from '@strapi/design-system';

const ConfigDiff = ({ isOpen, onClose, oldValue, newValue, configName }) => {
  const { formatMessage } = useIntl();
  if (!isOpen) return null;

  return (
    <ModalLayout
      onClose={onClose}
      labelledBy="title"
    >
      <ModalHeader>
        <Typography variant="omega" fontWeight="bold" textColor="neutral800">
          {formatMessage({ id: 'config-sync.ConfigDiff.Title' })} {configName}
        </Typography>
      </ModalHeader>
      <ModalBody>
        <Grid paddingBottom={4} style={{ textAlign: 'center' }}>
          <GridItem col={6}>
            <Typography variant="delta">{formatMessage({ id: 'config-sync.ConfigDiff.SyncDirectory' })}</Typography>
          </GridItem>
          <GridItem col={6}>
            <Typography variant="delta">{formatMessage({ id: 'config-sync.ConfigDiff.Database' })}</Typography>
          </GridItem>
        </Grid>
        <ReactDiffViewer
          oldValue={JSON.stringify(oldValue, null, 2)}
          newValue={JSON.stringify(newValue, null, 2)}
          splitView
          compareMethod={DiffMethod.WORDS}
        />
      </ModalBody>
    </ModalLayout>
  );
};

export default ConfigDiff;
