import type { Attribute, Common } from '..';
import type { Utils } from '../..';
export interface ComponentProperties<TComponentUID extends Common.UID.Component, TRepeatable extends Utils.Expression.BooleanValue = Utils.Expression.False> {
    component: TComponentUID;
    repeatable?: TRepeatable;
}
export type Component<TComponentUID extends Common.UID.Component = Common.UID.Component, TRepeatable extends Utils.Expression.BooleanValue = Utils.Expression.False> = Attribute.OfType<'component'> & ComponentProperties<TComponentUID, TRepeatable> & Attribute.ConfigurableOption & Attribute.MinMaxOption & Attribute.PrivateOption & Attribute.RequiredOption & Attribute.WritableOption & Attribute.VisibleOption;
export type ComponentValue<TComponentUID extends Common.UID.Component, TRepeatable extends Utils.Expression.BooleanValue> = Attribute.GetValues<TComponentUID> extends infer TValues ? Utils.Expression.If<TRepeatable, TValues[], TValues> : never;
export type GetComponentValue<TAttribute extends Attribute.Attribute> = TAttribute extends Component<infer TComponentUID, infer TRepeatable> ? ComponentValue<TComponentUID, TRepeatable> : never;
export type GetComponentTarget<TAttribute extends Attribute.Attribute> = TAttribute extends Component<infer TComponentUID> ? TComponentUID : never;
//# sourceMappingURL=component.d.ts.map