import { Job } from 'node-schedule';
import type { Strapi } from '@strapi/types';
interface JobSpec {
    job: Job;
    options: string | number | Date;
    name: string | null;
}
type TaskFn = ({ strapi }: {
    strapi: Strapi;
}, ...args: unknown[]) => Promise<unknown>;
type Task = TaskFn | {
    task: TaskFn;
    options: string;
};
interface Tasks {
    [key: string]: Task;
}
declare const createCronService: () => {
    add(tasks?: Tasks): any;
    remove(name: string): any;
    start(): any;
    stop(): any;
    destroy(): any;
    jobs: JobSpec[];
};
export default createCronService;
//# sourceMappingURL=cron.d.ts.map