import { join, extname, basename } from "path";
import fse from "fs-extra";
import { importDefault } from "@strapi/utils";
async function loadPolicies(strapi) {
  const dir = strapi.dirs.dist.policies;
  if (!await fse.pathExists(dir)) {
    return;
  }
  const policies = {};
  const paths = await fse.readdir(dir, { withFileTypes: true });
  for (const fd of paths) {
    const { name } = fd;
    const fullPath = join(dir, name);
    if (fd.isFile() && extname(name) === ".js") {
      const key = basename(name, ".js");
      policies[key] = importDefault(fullPath);
    }
  }
  strapi.container.get("policies").add(`global::`, policies);
}
export {
  loadPolicies as default
};
//# sourceMappingURL=policies.mjs.map
