import '@strapi/types';
declare const _default: () => {
    config: {
        default: {};
        validator(): void;
    };
    bootstrap: ({ strapi }: {
        strapi: Required<import("@strapi/types").Strapi>;
    }) => Promise<void>;
    services: {
        'content-types': typeof import("./services/content-types");
        components: typeof import("./services/components");
        'component-categories': typeof import("./services/component-categories");
        builder: typeof import("./services/builder");
        'api-handler': typeof import("./services/api-handler");
    };
    controllers: {
        builder: {
            getReservedNames(ctx: import("koa").Context): void;
        };
        'component-categories': {
            editCategory(ctx: import("koa").Context): Promise<any>;
            deleteCategory(ctx: import("koa").Context): Promise<void>;
        };
        components: {
            getComponents(ctx: import("koa").Context): Promise<void>;
            getComponent(ctx: import("koa").Context): Promise<any>;
            createComponent(ctx: import("koa").Context): Promise<any>;
            updateComponent(ctx: import("koa").Context): Promise<any>;
            deleteComponent(ctx: import("koa").Context): Promise<any>;
        };
        'content-types': {
            getContentTypes(ctx: import("koa").Context): Promise<any>;
            getContentType(ctx: import("koa").Context): any;
            createContentType(ctx: import("koa").Context): Promise<any>;
            updateContentType(ctx: import("koa").Context): Promise<any>;
            deleteContentType(ctx: import("koa").Context): Promise<any>;
        };
    };
    routes: {
        admin: {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
                config: {
                    policies: {
                        name: string;
                        config: {
                            actions: string[];
                        };
                    }[];
                };
            }[];
        };
        'content-api': {
            type: string;
            routes: {
                method: string;
                path: string;
                handler: string;
            }[];
        };
    };
};
export default _default;
//# sourceMappingURL=index.d.ts.map