'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const Flex = require('../../Flex/Flex.js');
const Box = require('../../Box/Box.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const SubNavSectionLabelWrapper = styled__default.default(Flex.Flex) `
  border: none;
  padding: 0;
  background: transparent;
`;
const DropDownIconWrapper = styled__default.default.div `
  display: flex;
  align-items: center;
  transform: rotateX(${({ rotated }) => (rotated ? '0deg' : '180deg')});
`;
const SubNavSectionLabel = ({ collapsable = false, label, onClick = () => { }, ariaExpanded, ariaControls, }) => {
    if (collapsable) {
        return (jsxRuntime.jsxs(SubNavSectionLabelWrapper, { as: "button", onClick: onClick, "aria-expanded": ariaExpanded, "aria-controls": ariaControls, textAlign: "left", children: [jsxRuntime.jsx(Box.Box, { paddingRight: 1, children: jsxRuntime.jsx(Typography.Typography, { variant: "sigma", textColor: "neutral600", children: label }) }), collapsable && (jsxRuntime.jsx(DropDownIconWrapper, { rotated: ariaExpanded, children: jsxRuntime.jsx(icons.CarretDown, { "aria-hidden": true }) }))] }));
    }
    return (jsxRuntime.jsx(SubNavSectionLabelWrapper, { children: jsxRuntime.jsx(Box.Box, { paddingRight: 1, children: jsxRuntime.jsx(Typography.Typography, { variant: "sigma", textColor: "neutral600", children: label }) }) }));
};

exports.SubNavSectionLabel = SubNavSectionLabel;
