'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const SubNavSectionLabel = require('./SubNavSectionLabel.js');
const useId = require('../../hooks/useId.js');
const Box = require('../../Box/Box.js');
const Flex = require('../../Flex/Flex.js');
const Badge = require('../../Badge/Badge.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const SubNavSectionWrapper = styled__default.default(Box.Box) `
  svg {
    height: ${4 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral500};
    }
  }
`;
const SubNavSection = ({ collapsable = false, label, badgeLabel, children, id }) => {
    const [isOpen, setOpenLinks] = React.useState(true);
    const listId = useId.useId(id);
    const handleClick = () => {
        setOpenLinks((prev) => !prev);
    };
    return (jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 1, children: [jsxRuntime.jsx(SubNavSectionWrapper, { paddingLeft: 6, paddingTop: 2, paddingBottom: 2, paddingRight: 4, children: jsxRuntime.jsxs(Box.Box, { position: "relative", paddingRight: badgeLabel ? 6 : 0, children: [jsxRuntime.jsx(SubNavSectionLabel.SubNavSectionLabel, { onClick: handleClick, ariaExpanded: isOpen, ariaControls: listId, collapsable: collapsable, label: label }), badgeLabel && (jsxRuntime.jsx(Badge.Badge, { backgroundColor: "neutral150", textColor: "neutral600", position: "absolute", right: 0, top: "50%", transform: "translateY(-50%)", children: badgeLabel }))] }) }), (!collapsable || isOpen) && (jsxRuntime.jsx("ol", { id: listId, children: React.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsxRuntime.jsx("li", { children: child }, index);
                }) }))] }));
};

exports.SubNavSection = SubNavSection;
