'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const useId = require('../../hooks/useId.js');
const Box = require('../../Box/Box.js');
const Flex = require('../../Flex/Flex.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const SubNavLinkSectionWrapper = styled__default.default(Box.Box) `
  svg {
    height: ${4 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral700};
    }
  }
`;
const SubNavLinkSectionButton = styled__default.default.button `
  border: none;
  padding: 0;
  background: transparent;
  display: flex;
  align-items: center;
`;
const DropDownIconWrapper = styled__default.default.div `
  display: flex;
  align-items: center;
  width: ${12 / 16}rem;
  transform: rotateX(${({ rotated }) => (rotated ? '0deg' : '180deg')});
`;
const SubNavLinkSection = ({ label, children, id }) => {
    const [isOpen, setOpenLinks] = React.useState(true);
    const listId = useId.useId(id);
    const handleClick = () => {
        setOpenLinks((prev) => !prev);
    };
    return (jsxRuntime.jsxs(Box.Box, { children: [jsxRuntime.jsx(SubNavLinkSectionWrapper, { paddingLeft: 7, paddingTop: 2, paddingBottom: 2, paddingRight: 4, children: jsxRuntime.jsx(Flex.Flex, { justifyContent: "space-between", children: jsxRuntime.jsxs(SubNavLinkSectionButton, { onClick: handleClick, "aria-expanded": isOpen, "aria-controls": listId, children: [jsxRuntime.jsx(DropDownIconWrapper, { rotated: isOpen, children: jsxRuntime.jsx(icons.CarretDown, { "aria-hidden": true }) }), jsxRuntime.jsx(Box.Box, { paddingLeft: 2, children: jsxRuntime.jsx(Typography.Typography, { as: "span", fontWeight: "semiBold", textColor: "neutral800", children: label }) })] }) }) }), isOpen && (jsxRuntime.jsx("ul", { id: listId, children: React.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsxRuntime.jsx("li", { children: child }, index);
                }) }))] }));
};

exports.SubNavLinkSection = SubNavLinkSection;
