'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const keyboardKeys = require('../../helpers/keyboardKeys.js');
const useId = require('../../hooks/useId.js');
const usePrevious = require('../../hooks/usePrevious.js');
const Divider = require('../../Divider/Divider.js');
const Box = require('../../Box/Box.js');
const SearchForm = require('../../Searchbar/SearchForm.js');
const Searchbar = require('../../Searchbar/Searchbar.js');
const Flex = require('../../Flex/Flex.js');
const Typography = require('../../Typography/Typography.js');
const IconButton = require('../../IconButton/IconButton.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CustomDivider = styled__default.default(Divider.Divider) `
  width: ${24 / 16}rem;
  background-color: ${({ theme }) => theme.colors.neutral200};
`;
const SubNavHeader = ({ as = 'h2', label, searchLabel = '', searchable = false, onChange = () => { }, value = '', onClear = () => { }, onSubmit = () => { }, id, }) => {
    const [isSearchOpen, setSearchOpen] = React.useState(false);
    const previousSearchOpenValue = usePrevious.usePrevious(isSearchOpen);
    const clearButtonId = useId.useId(id);
    const searchRef = React.useRef(undefined);
    const searchButtonRef = React.useRef(undefined);
    React.useEffect(() => {
        if (isSearchOpen && searchRef.current) {
            searchRef.current.focus();
        }
        if (previousSearchOpenValue && !isSearchOpen && searchButtonRef.current) {
            searchButtonRef.current.focus();
        }
    }, [isSearchOpen, previousSearchOpenValue]);
    const toggleSearch = () => {
        setSearchOpen((isOpen) => !isOpen);
    };
    const handleClear = (e) => {
        onClear(e);
        searchRef.current.focus();
    };
    const handleBlur = (e) => {
        if (e.relatedTarget?.id !== clearButtonId) {
            setSearchOpen(false);
        }
    };
    const handleKeyDown = (e) => {
        if (e.key === keyboardKeys.KeyboardKeys.ESCAPE) {
            setSearchOpen(false);
        }
    };
    if (isSearchOpen) {
        return (jsxRuntime.jsxs(Box.Box, { paddingLeft: 4, paddingTop: 5, paddingBottom: 2, paddingRight: 4, children: [jsxRuntime.jsx(SearchForm.SearchForm, { children: jsxRuntime.jsx(Searchbar.Searchbar, { name: "searchbar", value: value, onChange: onChange, placeholder: "e.g: strapi-plugin-abcd", onKeyDown: handleKeyDown, ref: searchRef, onBlur: handleBlur, onClear: handleClear, onSubmit: onSubmit, clearLabel: "Clear", size: "S", children: searchLabel }) }), jsxRuntime.jsx(Box.Box, { paddingLeft: 2, paddingTop: 4, children: jsxRuntime.jsx(CustomDivider, {}) })] }));
    }
    return (jsxRuntime.jsxs(Box.Box, { paddingLeft: 6, paddingTop: 6, paddingBottom: 2, paddingRight: 4, children: [jsxRuntime.jsxs(Flex.Flex, { justifyContent: "space-between", alignItems: "flex-start", children: [jsxRuntime.jsx(Typography.Typography, { variant: "beta", as: as, children: label }), searchable && (jsxRuntime.jsx(IconButton.IconButton, { ref: searchButtonRef, onClick: toggleSearch, label: searchLabel, icon: jsxRuntime.jsx(icons.Search, {}) }))] }), jsxRuntime.jsx(Box.Box, { paddingTop: 4, children: jsxRuntime.jsx(CustomDivider, {}) })] }));
};

exports.SubNavHeader = SubNavHeader;
