'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const Menu = require('./Menu.js');
const strings = require('../../helpers/strings.js');
const useId = require('../../hooks/useId.js');
const useIntersection = require('../../hooks/useIntersection.js');

const SimpleMenu = ({ children, onOpen, onClose, popoverPlacement, onReachEnd, ...props }) => {
    /**
     * Used for the intersection observer
     */
    const contentRef = React.useRef(null);
    const [internalIsOpen, setInternalIsOpen] = React.useState(false);
    const handleReachEnd = (entry) => {
        if (onReachEnd) {
            onReachEnd(entry);
        }
    };
    const handleOpenChange = (isOpen) => {
        if (isOpen && typeof onOpen === 'function') {
            onOpen();
        }
        else if (!isOpen && typeof onClose === 'function') {
            onClose();
        }
        setInternalIsOpen(isOpen);
    };
    const generatedId = useId.useId();
    const intersectionId = `intersection-${strings.stripReactIdOfColon(generatedId)}`;
    useIntersection.useIntersection(contentRef, handleReachEnd, {
        selectorToWatch: `#${intersectionId}`,
        /**
         * We need to know when the select is open because only then will viewportRef
         * not be null. Because it uses a portal that (sensibly) is not mounted 24/7.
         */
        skipWhen: !internalIsOpen,
    });
    return (jsxRuntime.jsxs(Menu.Root, { onOpenChange: handleOpenChange, children: [jsxRuntime.jsx(Menu.Trigger, { ...props, children: props.label }), jsxRuntime.jsx(Menu.Content, { intersectionId: intersectionId, popoverPlacement: popoverPlacement, children: children })] }));
};
const MenuItem = Menu.Item;

exports.Menu = Menu;
exports.MenuItem = MenuItem;
exports.SimpleMenu = SimpleMenu;
