import { jsxs, jsx } from 'react/jsx-runtime';
import React__default from 'react';
import { ChevronLeft, ChevronRight } from '@strapi/icons';
import styled from 'styled-components';
import { usePagination } from './PaginationContext.mjs';
import { buttonFocusStyle } from '../../themes/utils.mjs';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';
import { VisuallyHidden } from '../../VisuallyHidden/VisuallyHidden.mjs';
import { Typography } from '../../Typography/Typography.mjs';
import { Box } from '../../Box/Box.mjs';

const transientProps = {
    active: true,
};
const LinkWrapper = styled(BaseLink).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  padding: ${({ theme }) => theme.spaces[3]};
  border-radius: ${({ theme }) => theme.borderRadius};
  box-shadow: ${({ active, theme }) => (active ? theme.shadows.filterShadow : undefined)};
  text-decoration: none;
  display: flex;

  ${buttonFocusStyle}
`;
const PageLinkWrapper = styled(LinkWrapper) `
  color: ${({ theme, active }) => (active ? theme.colors.primary700 : theme.colors.neutral800)};
  background: ${({ theme, active }) => (active ? theme.colors.neutral0 : undefined)};

  &:hover {
    box-shadow: ${({ theme }) => theme.shadows.filterShadow};
  }
`;
const ActionLinkWrapper = styled(LinkWrapper) `
  font-size: ${11 / 16}rem;

  svg path {
    fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral600)};
  }

  &:focus,
  &:hover {
    svg path {
      fill: ${(p) => (p['aria-disabled'] ? p.theme.colors.neutral300 : p.theme.colors.neutral700)};
    }
  }

  ${(p) => p['aria-disabled']
    ? `
  pointer-events: none;
    `
    : undefined}
`;
const PreviousLink = React__default.forwardRef(({ children, ...props }, ref) => {
    const { activePage } = usePagination();
    const disabled = activePage === 1;
    return (jsxs(ActionLinkWrapper, { ref: ref, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsx(VisuallyHidden, { children: children }), jsx(ChevronLeft, { "aria-hidden": true })] }));
});
const NextLink = React__default.forwardRef(({ children, ...props }, ref) => {
    const { activePage, pageCount } = usePagination();
    const disabled = activePage === pageCount;
    return (jsxs(ActionLinkWrapper, { ref: ref, "aria-disabled": disabled, tabIndex: disabled ? -1 : undefined, ...props, children: [jsx(VisuallyHidden, { children: children }), jsx(ChevronRight, { "aria-hidden": true })] }));
});
const PageLink = React__default.forwardRef(({ number, children, ...props }, ref) => {
    const { activePage } = usePagination();
    const isActive = activePage === number;
    return (jsxs(PageLinkWrapper, { ref: ref, ...props, active: isActive, children: [jsx(VisuallyHidden, { children: children }), jsx(Typography, { "aria-hidden": true, fontWeight: isActive ? 'bold' : undefined, lineHeight: "revert", variant: "pi", children: number })] }));
});
const Dots = ({ children, ...props }) => (jsxs(Box, { ...props, children: [jsx(VisuallyHidden, { children: children }), jsx(Typography, { "aria-hidden": true, lineHeight: "revert", textColor: "neutral800", variant: "pi", children: "\u2026" })] }));

export { Dots, NextLink, PageLink, PreviousLink };
