import { jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { PaginationContext } from './PaginationContext.mjs';
import { Box } from '../../Box/Box.mjs';
import { Flex } from '../../Flex/Flex.mjs';

const Pagination = ({ children, label = 'Pagination', activePage, pageCount }) => {
    const context = React.useMemo(() => ({ activePage, pageCount }), [activePage, pageCount]);
    return (jsx(PaginationContext.Provider, { value: context, children: jsx(Box, { "aria-label": label, as: "nav", children: jsx(Flex, { as: "ol", gap: 1, children: React.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsx("li", { children: child }, index);
                }) }) }) }));
};

export { Pagination };
