'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const MainNavContext = require('./MainNavContext.js');
const Flex = require('../../Flex/Flex.js');
const Box = require('../../Box/Box.js');
const Divider = require('../../Divider/Divider.js');
const VisuallyHidden = require('../../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../../Typography/Typography.js');

const NavSection = ({ label, children, horizontal = false, spacing = 2, ...props }) => {
    const condensed = MainNavContext.useMainNav();
    if (condensed) {
        return (jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 2, children: [jsxRuntime.jsxs(Box.Box, { paddingTop: 1, paddingBottom: 1, background: "neutral0", hasRadius: true, as: "span", children: [jsxRuntime.jsx(Divider.Divider, {}), jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { children: jsxRuntime.jsx("span", { children: label }) })] }), jsxRuntime.jsx(Flex.Flex, { as: "ul", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React.Children.map(children, (child, index) => {
                        // eslint-disable-next-line react/no-array-index-key
                        return jsxRuntime.jsx("li", { children: child }, index);
                    }) })] }));
    }
    return (jsxRuntime.jsxs(Flex.Flex, { direction: "column", alignItems: "stretch", gap: 2, children: [jsxRuntime.jsx(Box.Box, { paddingTop: 1, paddingBottom: 1, background: "neutral0", paddingRight: 3, paddingLeft: 3, hasRadius: true, as: "span", children: jsxRuntime.jsx(Typography.Typography, { variant: "sigma", textColor: "neutral600", children: label }) }), jsxRuntime.jsx(Flex.Flex, { as: "ul", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React.Children.map(children, (child, index) => {
                    // eslint-disable-next-line react/no-array-index-key
                    return jsxRuntime.jsx("li", { children: child }, index);
                }) })] }));
};

exports.NavSection = NavSection;
