import { jsx, jsxs } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { useMainNav } from './MainNavContext.mjs';
import { Box } from '../../Box/Box.mjs';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';
import { Typography } from '../../Typography/Typography.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Badge } from '../../Badge/Badge.mjs';
import { Tooltip } from '../../Tooltip/Tooltip.mjs';

const IconBox = styled(Box) `
  svg {
    width: 1rem;
    height: 1rem;
  }
`;
const MainNavLinkWrapper = styled(BaseLink) `
  position: relative;
  text-decoration: none;
  display: block;
  border-radius: ${({ theme }) => theme.borderRadius};
  background: ${({ theme }) => theme.colors.neutral0};

  ${Typography} {
    color: ${({ theme }) => theme.colors.neutral600};
  }

  svg path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }

  &:hover {
    background: ${({ theme }) => theme.colors.neutral100};

    ${Typography} {
      color: ${({ theme }) => theme.colors.neutral700};
    }

    svg path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }

  &.active {
    background: ${({ theme }) => theme.colors.primary100};

    svg path {
      fill: ${({ theme }) => theme.colors.primary600};
    }

    ${Typography} {
      color: ${({ theme }) => theme.colors.primary600};
      font-weight: 500;
    }
  }
`;
const MainNavRow = styled(Flex) `
  padding: ${({ theme }) => `${theme.spaces[2]} ${theme.spaces[3]}`};
`;
const CustomBadge = styled(Badge) `
  ${({ theme, condensed }) => condensed &&
    `
	  position: absolute;
    // Values based on visual aspect 
    top: -${theme.spaces[3]};
    right:  -${theme.spaces[1]};
  `}

  ${Typography} {
    //find a solution to remove !important
    color: ${({ theme }) => theme.colors.neutral0} !important;
    line-height: 0;
  }

  display: flex;
  justify-content: center;
  align-items: center;
  min-width: ${({ theme }) => theme.spaces[6]};
  height: ${({ theme }) => theme.spaces[5]};
  padding: ${({ theme }) => `0 ${theme.spaces[2]}`};
  border-radius: ${({ theme }) => theme.spaces[10]};
  background: ${({ theme }) => theme.colors.primary600};
`;
const NavLink = React__default.forwardRef(({ children, icon, badgeContent, badgeAriaLabel, ...props }, ref) => {
    const condensed = useMainNav();
    if (condensed) {
        return (jsx(MainNavLinkWrapper, { ref: ref, ...props, children: jsx(Tooltip, { position: "right", label: children, children: jsxs(MainNavRow, { as: "span", justifyContent: "center", children: [jsx(IconBox, { "aria-hidden": true, paddingRight: 0, as: "span", children: icon }), badgeContent && (jsx(CustomBadge, { condensed: true, "aria-label": badgeAriaLabel, children: badgeContent }))] }) }) }));
    }
    return (jsx(MainNavLinkWrapper, { ref: ref, ...props, children: jsxs(MainNavRow, { as: "span", justifyContent: "space-between", children: [jsxs(Flex, { children: [jsx(IconBox, { "aria-hidden": true, paddingRight: 3, as: "span", children: icon }), jsx(Typography, { children: children })] }), badgeContent && (jsx(CustomBadge, { justifyContent: "center", "aria-label": badgeAriaLabel, children: badgeContent }))] }) }));
});

export { NavLink };
