'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const MainNavContext = require('./MainNavContext.js');
const Box = require('../../Box/Box.js');
const BaseLink = require('../../BaseLink/BaseLink.js');
const Typography = require('../../Typography/Typography.js');
const Flex = require('../../Flex/Flex.js');
const Badge = require('../../Badge/Badge.js');
const Tooltip = require('../../Tooltip/Tooltip.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const IconBox = styled__default.default(Box.Box) `
  svg {
    width: 1rem;
    height: 1rem;
  }
`;
const MainNavLinkWrapper = styled__default.default(BaseLink.BaseLink) `
  position: relative;
  text-decoration: none;
  display: block;
  border-radius: ${({ theme }) => theme.borderRadius};
  background: ${({ theme }) => theme.colors.neutral0};

  ${Typography.Typography} {
    color: ${({ theme }) => theme.colors.neutral600};
  }

  svg path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }

  &:hover {
    background: ${({ theme }) => theme.colors.neutral100};

    ${Typography.Typography} {
      color: ${({ theme }) => theme.colors.neutral700};
    }

    svg path {
      fill: ${({ theme }) => theme.colors.neutral600};
    }
  }

  &.active {
    background: ${({ theme }) => theme.colors.primary100};

    svg path {
      fill: ${({ theme }) => theme.colors.primary600};
    }

    ${Typography.Typography} {
      color: ${({ theme }) => theme.colors.primary600};
      font-weight: 500;
    }
  }
`;
const MainNavRow = styled__default.default(Flex.Flex) `
  padding: ${({ theme }) => `${theme.spaces[2]} ${theme.spaces[3]}`};
`;
const CustomBadge = styled__default.default(Badge.Badge) `
  ${({ theme, condensed }) => condensed &&
    `
	  position: absolute;
    // Values based on visual aspect 
    top: -${theme.spaces[3]};
    right:  -${theme.spaces[1]};
  `}

  ${Typography.Typography} {
    //find a solution to remove !important
    color: ${({ theme }) => theme.colors.neutral0} !important;
    line-height: 0;
  }

  display: flex;
  justify-content: center;
  align-items: center;
  min-width: ${({ theme }) => theme.spaces[6]};
  height: ${({ theme }) => theme.spaces[5]};
  padding: ${({ theme }) => `0 ${theme.spaces[2]}`};
  border-radius: ${({ theme }) => theme.spaces[10]};
  background: ${({ theme }) => theme.colors.primary600};
`;
const NavLink = React__default.default.forwardRef(({ children, icon, badgeContent, badgeAriaLabel, ...props }, ref) => {
    const condensed = MainNavContext.useMainNav();
    if (condensed) {
        return (jsxRuntime.jsx(MainNavLinkWrapper, { ref: ref, ...props, children: jsxRuntime.jsx(Tooltip.Tooltip, { position: "right", label: children, children: jsxRuntime.jsxs(MainNavRow, { as: "span", justifyContent: "center", children: [jsxRuntime.jsx(IconBox, { "aria-hidden": true, paddingRight: 0, as: "span", children: icon }), badgeContent && (jsxRuntime.jsx(CustomBadge, { condensed: true, "aria-label": badgeAriaLabel, children: badgeContent }))] }) }) }));
    }
    return (jsxRuntime.jsx(MainNavLinkWrapper, { ref: ref, ...props, children: jsxRuntime.jsxs(MainNavRow, { as: "span", justifyContent: "space-between", children: [jsxRuntime.jsxs(Flex.Flex, { children: [jsxRuntime.jsx(IconBox, { "aria-hidden": true, paddingRight: 3, as: "span", children: icon }), jsxRuntime.jsx(Typography.Typography, { children: children })] }), badgeContent && (jsxRuntime.jsx(CustomBadge, { justifyContent: "center", "aria-label": badgeAriaLabel, children: badgeContent }))] }) }));
});

exports.NavLink = NavLink;
