import { jsx, jsxs } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { useMainNav } from './MainNavContext.mjs';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';
import { Box } from '../../Box/Box.mjs';
import { VisuallyHidden } from '../../VisuallyHidden/VisuallyHidden.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Typography } from '../../Typography/Typography.mjs';

const BrandIconWrapper = styled.div `
  border-radius: ${({ theme }) => theme.borderRadius};

  svg,
  img {
    height: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
    width: ${({ condensed }) => (condensed ? `${40 / 16}rem` : `${32 / 16}rem`)};
  }
`;
const NavLinkWrapper = styled(BaseLink) `
  text-decoration: unset;
  color: inherit;
`;
const NavBrand = React__default.forwardRef(({ workplace, title, icon, ...props }, ref) => {
    const condensed = useMainNav();
    /**
     * TODO: this shouldn't be here, because we're assuming you're
     * passing a ReactRouter Link which isn't necessarily the case.
     */
    props.to = props?.to ?? '/';
    if (condensed) {
        return (jsx(BaseLink, { ref: ref, ...props, children: jsx(Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxs(BrandIconWrapper, { condensed: true, children: [icon, jsxs(VisuallyHidden, { children: [jsx("span", { children: title }), jsx("span", { children: workplace })] })] }) }) }));
    }
    return (jsx(NavLinkWrapper, { ref: ref, ...props, children: jsx(Box, { paddingLeft: 3, paddingRight: 3, paddingTop: 4, paddingBottom: 4, children: jsxs(Flex, { children: [jsx(BrandIconWrapper, { "aria-hidden": true, tabIndex: -1, children: icon }), jsxs(Box, { paddingLeft: 2, children: [jsxs(Typography, { fontWeight: "bold", textColor: "neutral800", as: "span", children: [title, jsx(VisuallyHidden, { as: "span", children: workplace })] }), jsx(Typography, { variant: "pi", as: "p", textColor: "neutral600", "aria-hidden": true, children: workplace })] })] }) }) }));
});

export { NavBrand };
