'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const utils = require('../../Button/utils.js');
const BaseButton = require('../../BaseButton/BaseButton.js');
const BaseLink = require('../../BaseLink/BaseLink.js');
const Flex = require('../../Flex/Flex.js');
const Typography = require('../../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const LinkWrapper = styled__default.default(BaseButton.BaseButtonWrapper) `
  text-decoration: none;

  &[aria-disabled='true'] {
    ${utils.getDisabledStyle}
    &:active {
      ${utils.getDisabledStyle}
    }
  }

  &:hover {
    ${utils.getHoverStyle}
  }

  &:active {
    ${utils.getActiveStyle}
  }

  ${utils.getVariantStyle}
`;
const LinkButton = React__default.default.forwardRef(({ variant = 'default', startIcon, endIcon, disabled = false, children, size = 'S', as = BaseLink.BaseLink, ...props }, ref) => {
    const paddingX = size === 'S' ? 2 : '10px';
    const paddingY = 4;
    return (jsxRuntime.jsxs(LinkWrapper, { ref: ref, "aria-disabled": disabled, size: size, variant: variant, background: "buttonPrimary600", borderColor: "buttonPrimary600", hasRadius: true, gap: 2, inline: true, paddingBottom: paddingX, paddingLeft: paddingY, paddingRight: paddingY, paddingTop: paddingX, pointerEvents: disabled ? 'none' : undefined, ...props, as: as || BaseLink.BaseLink, children: [startIcon && jsxRuntime.jsx(Flex.Flex, { "aria-hidden": true, children: startIcon }), jsxRuntime.jsx(Typography.Typography, { variant: size === 'S' ? 'pi' : undefined, fontWeight: "bold", textColor: "buttonNeutral0", children: children }), endIcon && jsxRuntime.jsx(Flex.Flex, { "aria-hidden": true, children: endIcon })] }));
});
LinkButton.displayName = 'LinkButton';

exports.LinkButton = LinkButton;
