import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { BaseLink } from '../../BaseLink/BaseLink.mjs';

const StyledLink = styled(BaseLink) `
  border-radius: ${({ theme }) => theme.borderRadius};
  color: ${({ theme }) => theme.colors.neutral600};
  font-size: ${({ theme }) => theme.fontSizes[1]};
  line-height: ${({ theme }) => theme.lineHeights[4]};
  padding: ${({ theme }) => `${theme.spaces[1]} ${theme.spaces[2]}`};
  text-decoration: none;

  :hover,
  :focus {
    background-color: ${({ theme }) => theme.colors.neutral200};
    color: ${({ theme }) => theme.colors.neutral700};
  }
`;
const CrumbLink = ({ children, ...props }) => jsx(StyledLink, { ...props, children: children });
CrumbLink.displayName = 'CrumbLink';

export { CrumbLink };
