import { jsx, jsxs } from 'react/jsx-runtime';
import { Children } from 'react';
import styled from 'styled-components';
import { Divider } from './Divider.mjs';
import { Flex } from '../../Flex/Flex.mjs';
import { Box } from '../../Box/Box.mjs';

const AlignedList = styled(Flex) `
  // CrumbLinks do have padding-x, because they need to have a
  // interaction effect, which mis-aligns the breadcrumbs on the left.
  // This normalizes the behavior by moving the first item to left by
  // the same amount it has inner padding
  :first-child {
    margin-left: ${({ theme }) => `calc(-1*${theme.spaces[2]})`};
  }
`;
const Breadcrumbs = ({ label, children, ...props }) => {
    const childrenArray = Children.toArray(children);
    return (jsx(Box, { "aria-label": label, ...props, children: jsx(AlignedList, { as: "ol", children: Children.map(childrenArray, (child, index) => {
                const shouldDisplayDivider = childrenArray.length > 1 && index + 1 < childrenArray.length;
                return (jsxs(Flex, { inline: true, as: "li", children: [child, shouldDisplayDivider && jsx(Divider, {})] }));
            }) }) }));
};
Breadcrumbs.displayName = 'Breadcrumbs';

export { Breadcrumbs };
