'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const Divider = require('./Divider.js');
const Flex = require('../../Flex/Flex.js');
const Box = require('../../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const AlignedList = styled__default.default(Flex.Flex) `
  // CrumbLinks do have padding-x, because they need to have a
  // interaction effect, which mis-aligns the breadcrumbs on the left.
  // This normalizes the behavior by moving the first item to left by
  // the same amount it has inner padding
  :first-child {
    margin-left: ${({ theme }) => `calc(-1*${theme.spaces[2]})`};
  }
`;
const Breadcrumbs = ({ label, children, ...props }) => {
    const childrenArray = React.Children.toArray(children);
    return (jsxRuntime.jsx(Box.Box, { "aria-label": label, ...props, children: jsxRuntime.jsx(AlignedList, { as: "ol", children: React.Children.map(childrenArray, (child, index) => {
                const shouldDisplayDivider = childrenArray.length > 1 && index + 1 < childrenArray.length;
                return (jsxRuntime.jsxs(Flex.Flex, { inline: true, as: "li", children: [child, shouldDisplayDivider && jsxRuntime.jsx(Divider.Divider, {})] }));
            }) }) }));
};
Breadcrumbs.displayName = 'Breadcrumbs';

exports.Breadcrumbs = Breadcrumbs;
