'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const lodash = require('lodash');
const index = require('./lightTheme/index.js');
const objects = require('../helpers/objects.js');

const generateError = (customMessage) => `
${customMessage}

The following is an example:


import { lightTheme, extendTheme } from '@strapi/design-system';

const myCustomTheme = extendTheme(lightTheme, {
    ${Object.keys(index.lightTheme)
    .map((key) => `${key}: /* put the overrides for the ${key} key */,`)
    .join('\n')}
})
`;
const extendTheme = (theme, overrides) => {
    if (!objects.isObject(theme)) {
        const error = generateError('The first argument should be an object and corresponds to the theme you want to extend.');
        throw new Error(error);
    }
    if (!objects.isObject(overrides)) {
        const error = generateError('The second argument should be an object and corresponds to the keys of the theme you want to override.');
        throw new Error(error);
    }
    function customizer(objValue, srcValue) {
        if (Array.isArray(objValue)) {
            return srcValue;
        }
        if (objects.isObject(objValue) && objects.isObject(srcValue)) {
            return lodash.merge(objValue, srcValue);
        }
        return undefined;
    }
    const masterTheme = lodash.cloneDeep(theme ?? {});
    const masterOverrides = lodash.cloneDeep(overrides ?? {});
    lodash.assignWith(masterTheme, masterOverrides, customizer);
    return masterTheme;
};

exports.extendTheme = extendTheme;
