'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');
const uiPrimitives = require('@strapi/ui-primitives');

const useResizeObserver = (sources, onResize) => {
    const handleResize = uiPrimitives.useCallbackRef(onResize);
    React.useLayoutEffect(() => {
        const resizeObs = new ResizeObserver(handleResize);
        if (Array.isArray(sources)) {
            sources.forEach((source) => {
                if (source.current) {
                    resizeObs.observe(source.current);
                }
            });
        }
        else if (sources.current) {
            resizeObs.observe(sources.current);
        }
        return () => {
            resizeObs.disconnect();
        };
    }, [sources, handleResize]);
};

exports.useResizeObserver = useResizeObserver;
