'use strict';

const React = require('react');

const useLockScroll = (lockScroll) => {
    React.useEffect(() => {
        if (lockScroll) {
            document.body.classList.add('lock-body-scroll');
        }
        return () => {
            document.body.classList.remove('lock-body-scroll');
        };
    }, [lockScroll]);
};

module.exports = useLockScroll;
