'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);

// Inspired by radix-ui useId hook https://github.com/radix-ui/primitives/blob/main/packages/react/id/src/id.tsx
// We `toString()` to prevent bundlers from trying to `import { useId } from 'react';`
const useReactId = React__default.default['useId'.toString()] || (() => undefined);
let count = 0;
const useId = (initialId) => {
    const [id, setId] = React.useState(useReactId());
    // React versions older than 18 will have client-side ids only.
    React.useLayoutEffect(() => {
        if (!initialId)
            setId((reactId) => reactId ?? String(count++));
    }, [initialId]);
    return initialId?.toString() ?? (id || '');
};

exports.useId = useId;
