'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');

const useElementOnScreen = (options) => {
    const containerRef = React.useRef(null);
    const [isVisible, setIsVisible] = React.useState(true);
    const callback = ([entry]) => {
        setIsVisible(entry.isIntersecting);
    };
    React.useEffect(() => {
        const containerEl = containerRef.current;
        const observer = new IntersectionObserver(callback, options);
        if (containerEl) {
            observer.observe(containerRef.current);
        }
        return () => {
            if (containerEl) {
                observer.disconnect();
            }
        };
    }, [containerRef, options]);
    return [containerRef, isVisible];
};

exports.useElementOnScreen = useElementOnScreen;
