import { once, PREFIX } from './deprecations.mjs';
import { useResizeObserver as useResizeObserver$1 } from '../hooks/useResizeObserver.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated useResizeObserver has moved. Please import it from "@strapi/design-system/hooks/useResizeObserver"
 */
const useResizeObserver = (...args) => {
    warnDeprecated(`${PREFIX} useResizeObserver has moved. Please import it from "@strapi/design-system/hooks/useResizeObserver"`);
    return useResizeObserver$1(...args);
};

export { useResizeObserver };
