'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const deprecations = require('./deprecations.js');
const usePrevious$1 = require('../hooks/usePrevious.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated usePrevious has moved. Please import it from "@strapi/design-system/hooks/usePrevious"
 */
const usePrevious = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} usePrevious has moved. Please import it from "@strapi/design-system/hooks/usePrevious"`);
    return usePrevious$1.usePrevious(...args);
};

exports.usePrevious = usePrevious;
