import { once, PREFIX } from './deprecations.mjs';
import useLockScroll$1 from '../hooks/useLockScroll.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated useLockScroll has moved. Please import it from "@strapi/design-system/hooks/useLockScroll"
 */
const useLockScroll = (...args) => {
    warnDeprecated(`${PREFIX} useLockScroll has moved. Please import it from "@strapi/design-system/hooks/useLockScroll"`);
    return useLockScroll$1(...args);
};

export { useLockScroll as default };
