'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const deprecations = require('./deprecations.js');
const useIntersection$1 = require('../hooks/useIntersection.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated useId has moved. Please import it from "@strapi/design-system/hooks/useId"
 */
const useIntersection = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} useIntersection has moved. Please import it from "@strapi/design-system/hooks/useIntersection"`);
    return useIntersection$1.useIntersection(...args);
};

exports.useIntersection = useIntersection;
