import { once, PREFIX } from './deprecations.mjs';
import { useId as useId$1 } from '../hooks/useId.mjs';

const warnDeprecated = once(console.warn);
/**
 * @preserve
 * @deprecated useId has moved. Please import it from "@strapi/design-system/hooks/useId"
 */
const useId = (...args) => {
    warnDeprecated(`${PREFIX} useId has moved. Please import it from "@strapi/design-system/hooks/useId"`);
    return useId$1(...args);
};

export { useId };
