'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const deprecations = require('./deprecations.js');
const useElementOnScreen$1 = require('../hooks/useElementOnScreen.js');

const warnDeprecated = deprecations.once(console.warn);
/**
 * @preserve
 * @deprecated useElementOnScreen has moved. Please import it from "@strapi/design-system/hooks/useElementOnScreen"
 */
const useElementOnScreen = (...args) => {
    warnDeprecated(`${deprecations.PREFIX} useElementOnScreen has moved. Please import it from "@strapi/design-system/hooks/useElementOnScreen"`);
    return useElementOnScreen$1.useElementOnScreen(...args);
};

exports.useElementOnScreen = useElementOnScreen;
