const PREFIX = '[@strapi/design-system]:';
const once = (fn) => {
    const func = fn;
    let called = false;
    if (typeof func !== 'function') {
        throw new TypeError(`${PREFIX} once requires a function parameter`);
    }
    return (...args) => {
        if (!called) {
            func(...args);
            called = true;
        }
    };
};

export { PREFIX, once };
