import { jsx } from 'react/jsx-runtime';
import * as React from 'react';

const createContext = (rootComponentName, defaultContext) => {
    const Context = React.createContext(defaultContext);
    function Provider(props) {
        const { children, ...context } = props;
        // Only re-memoize when prop values change
        // eslint-disable-next-line react-hooks/exhaustive-deps
        const value = React.useMemo(() => context, Object.values(context));
        return jsx(Context.Provider, { value: value, children: children });
    }
    function useContext(consumerName) {
        const context = React.useContext(Context);
        if (context)
            return context;
        if (defaultContext !== undefined)
            return defaultContext;
        // if a defaultContext wasn't specified, it's a required context.
        throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
    }
    Provider.displayName = `${rootComponentName}Provider`;
    return [Provider, useContext];
};

export { createContext };
