import styled from 'styled-components';
import { variantStyle, ellipsisStyle } from './utils.mjs';
import { extractStyleFromTheme } from '../helpers/theme.mjs';

const transientProps = {
    fontSize: true,
    fontWeight: true,
};
const Typography = styled.span.withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  ${variantStyle}
  ${ellipsisStyle}

  // These properties need to come after {variantStyle}, because they might
  // overwrite a variant attribute
  font-weight: ${({ theme, fontWeight }) => extractStyleFromTheme(theme.fontWeights, fontWeight, undefined)};
  font-size: ${({ theme, fontSize }) => extractStyleFromTheme(theme.fontSizes, fontSize, undefined)};
  line-height: ${({ theme, lineHeight }) => extractStyleFromTheme(theme.lineHeights, lineHeight, lineHeight)};
  color: ${({ theme, textColor }) => theme.colors[textColor || 'neutral800']};
  text-align: ${({ textAlign }) => textAlign};
  text-decoration: ${({ textDecoration }) => textDecoration};
  text-transform: ${({ textTransform }) => textTransform};
`;

export { Typography };
