'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const styled = require('styled-components');
const utils = require('./utils.js');
const theme = require('../helpers/theme.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const transientProps = {
    fontSize: true,
    fontWeight: true,
};
const Typography = styled__default.default.span.withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  ${utils.variantStyle}
  ${utils.ellipsisStyle}

  // These properties need to come after {variantStyle}, because they might
  // overwrite a variant attribute
  font-weight: ${({ theme: theme$1, fontWeight }) => theme.extractStyleFromTheme(theme$1.fontWeights, fontWeight, undefined)};
  font-size: ${({ theme: theme$1, fontSize }) => theme.extractStyleFromTheme(theme$1.fontSizes, fontSize, undefined)};
  line-height: ${({ theme: theme$1, lineHeight }) => theme.extractStyleFromTheme(theme$1.lineHeights, lineHeight, lineHeight)};
  color: ${({ theme, textColor }) => theme.colors[textColor || 'neutral800']};
  text-align: ${({ textAlign }) => textAlign};
  text-decoration: ${({ textDecoration }) => textDecoration};
  text-transform: ${({ textTransform }) => textTransform};
`;

exports.Typography = Typography;
