'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const useTooltipHandlers = require('./hooks/useTooltipHandlers.js');
const useTooltipLayout = require('./hooks/useTooltipLayout.js');
const useId = require('../hooks/useId.js');
const Portal = require('../Portal/Portal.js');
const Box = require('../Box/Box.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const TooltipWrapper = styled__default.default(Box.Box) `
  /* z-index exist because of its position inside Modals */
  z-index: 4;
  display: ${({ visible }) => (visible ? 'revert' : 'none')};
`;
const Tooltip = ({ children, label, description, delay = 500, position = 'top', id, ...props }) => {
    const tooltipId = useId.useId(id);
    const descriptionId = useId.useId();
    const { visible, ...tooltipHandlers } = useTooltipHandlers.useTooltipHandlers(delay);
    const { tooltipWrapperRef, toggleSourceRef } = useTooltipLayout.useTooltipLayout(visible, position);
    const childrenClone = React__namespace.cloneElement(children, {
        tabIndex: 0,
        'aria-labelledby': label ? tooltipId : undefined,
        'aria-describedby': description ? tooltipId : undefined,
        ...tooltipHandlers,
    });
    return (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(Portal.Portal, { children: jsxRuntime.jsxs(TooltipWrapper, { id: tooltipId, background: "neutral900", hasRadius: true, padding: 2, role: "tooltip", ref: tooltipWrapperRef, visible: visible, position: "absolute", ...props, children: [visible && jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { id: descriptionId, children: description }), jsxRuntime.jsx(Typography.Typography, { as: "p", variant: "pi", fontWeight: "bold", textColor: "neutral0", children: label || description })] }) }), jsxRuntime.jsx("span", { ref: toggleSourceRef, children: childrenClone })] }));
};

exports.Tooltip = Tooltip;
